package csbase.client.util;

import java.awt.Component;

import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.table.DefaultTableCellRenderer;

import tecgraf.javautils.core.lng.FormatUtils;

/**
 * Renderizador de clulas para tamanhos em bytes.
 */
public class SizeTableCellRenderer extends DefaultTableCellRenderer {

  /**
   * {@inheritDoc}
   */
  @Override
  public Component getTableCellRendererComponent(JTable table, Object value,
    boolean isSelected, boolean hasFocus, int row, int column) {
    super.getTableCellRendererComponent(table, value, isSelected, hasFocus,
      row, column);
    if (value instanceof Long) {
      final Long sz = (Long) value;
      if (sz < 0) {
        setText("---");
        setHorizontalAlignment(SwingConstants.CENTER);
      }
      else {
        setText(FormatUtils.formatSize(sz, 2));
        setHorizontalAlignment(SwingConstants.RIGHT);
      }

    }
    return this;
  }

}
