/*
 * $Id: ApplicationComponentPanel.java 146586 2013-11-06 20:52:32Z mjulia $
 */
package csbase.client.applications;

import javax.swing.JPanel;

/**
 * Painel genrico de uma aplicao.
 * 
 * @author Tecgraf/PUC-Rio
 * @param <A> o classe da aplicao envolvida.
 */
public class ApplicationComponentPanel<A extends Application> extends JPanel {

  /**
   * O programa
   */
  final private A application;

  /**
   * Consulta uma string internacionalizada.
   * 
   * @param tag tag
   * @return o texto
   */
  final public String getString(final String tag) {
    return application.getClassString(this.getClass(), tag);
  }

  /**
   * Consulta ao programa
   * 
   * @return o programa
   */
  final public A getApplication() {
    return application;
  }

  /**
   * Construtor.
   * 
   * @param application aplicao
   */
  public ApplicationComponentPanel(final A application) {
    this.application = application;
  }
}
