package csbase.client.applications.algorithmsmanager.actions;

import java.awt.event.ActionEvent;

import javax.swing.ImageIcon;

import csbase.client.applications.algorithmsmanager.dialogs.CommonSelectionPanel;

/**
 * Classe abstrata que define uma ao comum  edio de dados, nas
 * funcionalidades de gerenciamento de categorias e gerenciamento de algoritmos,
 * na aplicao Gerenciador de Algoritmos.
 * 
 * Uma ao desse tipo  sempre originada de uma operao (por exemplo, de
 * criao, remoo ou atualizao) realizada no painel de seleo de dados de
 * uma das funcionalidades acima.
 * 
 * Essa classe deve ser especializada para que trate de maneira adequada a
 * operao de edio realizada sobre um ou mais dados selecionados, que pode
 * ser por exemplo, as operaes de criao, remoo ou atualizao do dado.
 * Isso  feito atravs da redefinio do mtodo
 * <code> handleEditOperation </code>.
 * 
 */
public abstract class CommonEditAction extends AlgorithmsManagerAction {
  /** Painel de gerncia de categorias que criou essa ao */
  private CommonSelectionPanel selectionPanel;

  /**
   * Constri a ao de remover categorias de algoritmos.
   * 
   * @param selectionPanel painel pai que criou a ao
   * @param icon imagem da ao
   */
  public CommonEditAction(CommonSelectionPanel selectionPanel, ImageIcon icon) {
    super(selectionPanel.getApplication(), icon);
    this.selectionPanel = selectionPanel;
  }

  /**
   * Trata a operao de edio realizada sobre um ou mais dados selecionados.
   */
  protected abstract void handleEditOperation();

  /**
   * (non-Javadoc)
   * 
   * @see csbase.client.applications.algorithmsmanager.actions.AlgorithmsManagerAction#handleActionPerformed(java.awt.event.ActionEvent)
   */
  @Override
  protected void handleActionPerformed(ActionEvent ae) throws Exception {
    handleEditOperation();
  }

  /**
   * Obtm o painel de seleo, onde foi originada essa ao.
   * 
   * @return o painel de seleo, onde foi originada essa ao
   */
  public CommonSelectionPanel getSelectionPanel() {
    return (CommonSelectionPanel) selectionPanel;
  }
}
