/*
 * $Id$
 */

package csbase.client.applications.commandsmonitor.table.column;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.rmi.RemoteException;
import java.util.Locale;

import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

import csbase.client.algorithms.commands.cache.CommandsCache;
import csbase.client.applications.ApplicationImages;
import csbase.client.desktop.RemoteTask;
import csbase.logic.CommandInfo;
import csbase.logic.User;
import csbase.logic.applicationservice.ApplicationRegistry;

/**
 * Coluna contendo a posio do comando na fila do agendador de comandos.
 * 
 * @author Tecgraf / PUC-Rio
 */
public class PositionColumn extends AbstractCommandsTableColumn {

  /**
   * Renderiza a coluna de descrio com um cone de um lpis no lado esquerdo,
   * indicando que a mesma  editvel.
   */
  private static final DefaultTableCellRenderer EDITABLE_CELL_RENDERER;

  static {
    EDITABLE_CELL_RENDERER = new DefaultTableCellRenderer();
    EDITABLE_CELL_RENDERER
      .setIcon(ApplicationImages.ICON_EDITABLE_TABLE_CELL_14);
  }

  /**
   * Construtor.
   * 
   * @param id Identificador da coluna.
   * @param appRegistry registro da aplicao que ser utilizado para se obter o
   *        nome da coluna de acordo com o {@link Locale}.
   */
  public PositionColumn(String id, ApplicationRegistry appRegistry) {
    super(Integer.class, id, appRegistry, User.getLoggedUser().isAdmin());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object getValue(CommandInfo cmd) {
    return cmd.getGlobalPosition();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void setValue(final CommandInfo cmd, final Object value) {
    int previousPosition = cmd.getGlobalPosition();

    String position = value.toString();
    cmd.setGlobalPosition(position.isEmpty() ? 0
      : Integer.parseInt(position) - 1);

    RemoteTask<Boolean> task = new RemoteTask<Boolean>() {
      @Override
      protected void performTask() throws RemoteException {
        setResult(CommandsCache.getInstance().updatePosition(cmd));
      }
    };
    String taskTitle = getGenericString("task.command.update.title");
    String taskMessage = getGenericString("task.command.update.message");
    boolean success = task.execute(null, taskTitle, taskMessage);
    if (!success || !task.getResult()) {
      cmd.setGlobalPosition(previousPosition);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public TableCellRenderer createTableCellRenderer() {
    return isColumnEditable() ? EDITABLE_CELL_RENDERER : null;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public TableCellEditor createTableCellEditor() {
    JTextField textField = new JTextField();
    textField.addKeyListener(new KeyAdapter() {
      @Override
      public void keyTyped(KeyEvent ev) {
        if ((!Character.isDigit(ev.getKeyChar()))
          && (!(ev.getKeyChar() == KeyEvent.VK_BACK_SPACE))) {
          ev.consume();
        }
      }
    });
    textField.setColumns(5);
    return new DefaultCellEditor(textField);
  }
}
