package csbase.client.applications.flowapplication.actions;

import java.awt.event.ActionEvent;
import java.util.Vector;

import javax.swing.JOptionPane;

import csbase.client.algorithms.tasks.OutdatedFlowInfo;
import csbase.client.algorithms.tasks.OutdatedFlowTask;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.flowapplication.FlowApplication;
import csbase.client.desktop.DesktopFrame;

/**
 * Ao que busca os fluxos desatualizados e abre uma janela de relatrio para
 * mostrar
 * 
 *
 * @author Tecgraf/PUC-Rio
 */
public class ListOutdatedFlowsAction extends FlowApplicationAction {

  /** Dilogo */
  private ListOutdatedFlowDialog dialog;

  /**
   * Construtor
   * 
   * @param application a aplicao.
   */
  public ListOutdatedFlowsAction(FlowApplication application) {
    super(application, null);
  }

  /** {@inheritDoc} */
  @Override
  protected void handleActionPerformed(ActionEvent ae) throws Exception {
    doAction();
  }

  /**
   * Faz a ao efetivamente
   */
  private void doAction() {
    String resultTitle = getClassString("updating.flows");

    OutdatedFlowTask task = new OutdatedFlowTask();

    ApplicationFrame window = getApplication().getApplicationFrame();
    String title = DesktopFrame.getInstance().getTitle();
    String message = getClassString("searching.outdated.flow");

    try {
      task.execute(window, title, message);
    }
    catch (Exception e) {
      JOptionPane.showMessageDialog(window, getClassString(
        "error.searching.flows"), resultTitle, JOptionPane.PLAIN_MESSAGE);
      return;
    }

    Vector<OutdatedFlowInfo> result = task.getResult();

    if (result.size() <= 0) {
      JOptionPane.showMessageDialog(window, getClassString("all.updated"),
        resultTitle, JOptionPane.PLAIN_MESSAGE);
    }
    else {

      if (dialog == null) {
        dialog = new ListOutdatedFlowDialog(getApplication(), result);//, getSelectionPanel());
      }
      else {
        dialog.setData(result);//, getSelectionPanel());
      }
      dialog.setVisible(true);

    }
  }

  /**
   * Atualiza em funo de um reload
   */
  public void updateToReload() {
    if (dialog != null && dialog.isVisible()) {
      doAction();
    }
  }
}