package csbase.client.applications.flowapplication.messages;

import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;

import tecgraf.vix.Message;
import csbase.client.applications.flowapplication.graph.GraphElement;

/**
 * Mensagem de "colar" o contedo da rea de transferncia.
 */
public final class PasteMessage extends Message {

  /**
   * O contedo a ser "colado"
   */
  private Transferable transferable;

  /**
   * Os elementos afetados pela mensagem.
   */
  private Collection<GraphElement> affectedElements;

  /**
   * Obtm o contedo a ser "colado".
   * 
   * @return o contedo a ser "colado".
   */
  public Transferable getTransferable() {
    return this.transferable;
  }

  /**
   * Atribui o contedo a ser "colado".
   * 
   * @param transferable o contedo a ser "colado".
   */
  public void setTransferable(final Transferable transferable) {
    this.transferable = transferable;
  }

  /**
   * Atribui os elementos afetados pela mensagem. Caso seja um nico elemento,
   * usar {@link #setAffectedElement(GraphElement)}.
   * 
   * @param elements os elementos afetados.
   */
  public void setAffectedElements(Collection<GraphElement> elements) {
    this.affectedElements = elements;
  }

  /**
   * Atribui o elemento afetado pela mensagem.
   * 
   * @param element o elemento afetado.
   */
  public void setAffectedElement(GraphElement element) {
    this.affectedElements = new ArrayList<GraphElement>();
    affectedElements.add(element);
  }

  /**
   * Obtm os elementos afetados pela mensagem.
   * 
   * @return os elementos afetados.
   */
  public Collection<GraphElement> getAffectedElements() {
    return this.affectedElements;
  }
}
