package csbase.client.remote.manager.server;

import csbase.logic.server.ServerInfo;

import java.util.EventListener;

/**
 * Representa um ouvinte que deseja capturar mudanas no repositrio de
 * informao de servidores.
 * 
 * @author Tecgraf/PUC-Rio
 */
public interface ServerInfoManagerListener extends EventListener {
  /**
   *  chamado quando informaes de um servidor so adicionadas ao repositrio.
   *
   * @param addedServerInfo Informaes adicionadas.
   */
  void wasAddedServerInfo(ServerInfo addedServerInfo);

  /**
   *  chamado quando informaes de um servidor so removidas do repositrio.
   *
   * @param removedServerInfo Informaes removidas.
   */
  void wasRemovedServerInfo(ServerInfo removedServerInfo);

  /**
   *  chamado quando informaes de um servidor so alteradas.
   *
   * @param oldServerInfo Informaes do servidor em seu estado antigo.
   * @param newServerInfo Informaes do servidor em seu estado atual.
   */
  void wasModifiedServerInfo(
    ServerInfo oldServerInfo, ServerInfo newServerInfo);
}
