package csbase.client.util.event;

/**
 * @author Tecgraf / PUC-Rio
 * 
 * Representa um ouvinte de eventos. Se inserido na estrutura de um
 * {@link EventManager}, este ir receber todos os eventos de um tipo
 * especfico que foram lanados atravs daquele {@link EventManager}.
 * 
 * @param <T> tipo de evento que se tem interesse.
 */
public interface EventListener<T extends IEvent> {
  /**
   * Mtodo a ser chamado em um {@link EventManager} quando um evento do tipo
   * {@code <T>} for disparado atravs dele.<br>
   * Este mtodo deve ser sobrescrito para tratar o evento disparado.
   * 
   * @param event evento disparado.
   */
  public void eventFired(T event);
}
