package csbase.logic;

import java.util.Map;

/**
 * Classe que representa os dados de mensagem de sucesso na execuo de um
 * comando em um SGA. Essa notificao indica que o comando terminou sua
 * execuo com sucesso.
 *
 * @author Tecgraf
 */
public class CommandSuccessNotification extends
  ExtendedCommandFinishedNotification {

  /**
   * Mapa de informaes de execuo do comando.
   */
  private Map<String, String> executionData;

  /**
   * {@inheritDoc}
   */
  @Override
  protected String getStatusString() {
    return "CMD/SUCCESS";
  }

  /**
   * Constri o evento de trmino de comando.
   *
   * @param sender Quem est enviando a notificao (no pode ser {@code null}).
   * @param commandId identificador do comando.
   * @param cmdDesc descrio do comando.
   * @param tip Dica para auxiliar a identificao do algoritmo do comando.
   * @param elapsedTimeSec tempo de parede.
   * @param userTimeSec tempo em modo usurio.
   * @param cpuTimeSec tempo em modo sistema.
   * @param startTime Hora de incio
   * @param endTime Hora de trmino.
   * @param execHost Servidor de execuo.
   * @param projectId identificador do projeto
   * @param finalizationInfo Informaes sobre a finalizao do comando.
   * @param executionData Mapa de informaes sobre a execuo do comando.
   */
  public CommandSuccessNotification(String sender, Object commandId,
    String cmdDesc, String tip, Integer elapsedTimeSec, Integer userTimeSec,
    Integer cpuTimeSec, long startTime, long endTime, String execHost,
    Object projectId, CommandFinalizationInfo finalizationInfo,
    Map<String, String> executionData) {
    super(sender, commandId, cmdDesc, tip, elapsedTimeSec, userTimeSec,
      cpuTimeSec, startTime, endTime, execHost, projectId, finalizationInfo);
    this.executionData = executionData;
  }

  /**
   * Obtm o mapa de informaes sobre a execuo do comando.
   *
   * @return mapa de informaes sobre a execuo do comando.
   */
  public Map<String, String> getExecutionData() {
    return this.executionData;
  }
}
