package csbase.logic.algorithms.parameters;

/**
 * Observador de Parmetro do Tipo URL.
 */
public interface URLParameterListener {
  /**
   * Indica que houve mudana no tipo de arquivo aceito por um parmetro.
   * 
   * @param parameter O parmetro (No aceita {@code null}).
   */
  void typeWasChanged(URLParameter parameter);

  /**
   * Indica que uma conexo foi criada/destruda.
   * 
   * @param parameter O parmetro (No aceita {@code null}) que ganhou ou perdeu
   *        a conexo.
   */
  void hasLinkWasChanged(URLParameter parameter);

}
