/*
 * $Author:$ $Date:$ $Release:$
 */
package csbase.logic.algorithms.parameters.triggers;

import csbase.logic.algorithms.parameters.TextParameter;
import csbase.logic.algorithms.parameters.conditions.Condition;

/**
 * Gatilho Proibir Editar Parmetro: Torna um {@link TextParameter parmetro}
 * no-editvel quando a {@link Condition condio} associada for aceita.
 * 
 * @author lmoreira
 */
public final class ProhibitEditParameterTrigger extends Trigger<TextParameter> {
  /**
   * Cria o gatilho.
   * 
   * @param parameter O parmetro (No aceita {@code null}).
   * @param condition A condio (No aceita {@code null}).
   */
  public ProhibitEditParameterTrigger(TextParameter parameter,
    Condition condition) {
    super(parameter, condition);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void doAction() {
    getParameter().setEditable(false);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void undoAction() {
    getParameter().setEditable(true);
  }
}