/*
 * $Author:$ $Date:$ $Release:$
 */
package csbase.logic.algorithms.parameters.validators;

import java.rmi.RemoteException;
import java.util.List;

import csbase.logic.algorithms.FileParameterValue;
import csbase.logic.algorithms.parameters.FileListParameter;
import csbase.logic.algorithms.parameters.InputFileListParameter;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.validation.LocalizedMessage;
import csbase.logic.algorithms.validation.Validation;
import csbase.logic.algorithms.validation.ValidationContext;
import csbase.logic.algorithms.validation.ValidationError;
import csbase.logic.algorithms.validation.ValidationMode;
import csbase.logic.algorithms.validation.ValidationSuccess;

/**
 * Validador do {@link InputFileListParameter Parmetro do Tipo Lista de Arquivo
 * de Entrada}.
 * 
 * @author lmoreira
 */
public final class FileListParameterValidator extends
  ListParameterValidator<FileParameterValue> {

  /**
   * Cria um validador de uma lista de arquivos.
   * 
   * @param fileValidator o validor de um arquivo individual.
   */
  public FileListParameterValidator(FileParameterValidator fileValidator) {
    super(fileValidator);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public final Validation validateValue(SimpleParameter<?> parameter,
    List<FileParameterValue> values, ValidationContext context)
    throws RemoteException {
    if (!parameter.isVisible() || !parameter.isEnabled()) {
      return new ValidationSuccess();
    }
    if ((values == null) || values.isEmpty()) {
      if (isOptional() || getMode().equals(ValidationMode.ALLOW_EMPY_VALUES)) {
        return new ValidationSuccess();
      }
      LocalizedMessage message =
        new LocalizedMessage(ListParameterValidator.class, "empty_value",
          new Object[] { parameter.getLabel() });
      return new ValidationError(message);
    }
    Validation result;
    FileListParameter fileListParameter = (FileListParameter) parameter;
    for (FileParameterValue file : values) {
      FileParameterValidator validator = getItemValidator();
      result =
        validator.validateFile(file, fileListParameter.getMode(),
          context.getProjectId(), fileListParameter.mustExist());
      if (!result.isWellSucceded()) {
        return result;
      }
    }
    return new ValidationSuccess();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public FileParameterValidator getItemValidator() {
    return (FileParameterValidator) super.getItemValidator();
  }

}
