/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

import csbase.logic.Permission;
import java.util.regex.PatternSyntaxException;

public abstract class AttributesPermission
extends Permission {
    String[] attributes;

    public AttributesPermission() {
    }

    public AttributesPermission(String name, String description, String[] attributes) {
        super(name, description);
        this.attributes = attributes;
    }

    public String[] getAttributes() {
        return this.attributes;
    }

    public void setAttributes(String[] attributes) {
        this.attributes = attributes;
    }

    public boolean hasAttribute(String attribute) {
        int i = 0;
        while (i < this.attributes.length) {
            if (this.attributes[i].equals(attribute)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasMatchAttribute(String text) {
        return this.getMatchAttribute(text) != null;
    }

    public String getMatchAttribute(String text) {
        int i = 0;
        while (i < this.attributes.length) {
            try {
                if (text.equals(this.attributes[i]) || text.matches(this.attributes[i])) {
                    return this.attributes[i];
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
            ++i;
        }
        return null;
    }

    @Override
    public boolean equalContents(Object obj) {
        if (!super.equalContents(obj)) {
            return false;
        }
        if (!(obj instanceof AttributesPermission)) {
            return false;
        }
        AttributesPermission permission = (AttributesPermission)obj;
        String[] pAttributes = permission.getAttributes();
        if (pAttributes.length != this.attributes.length) {
            return false;
        }
        int i = 0;
        while (i < pAttributes.length) {
            if (!pAttributes[i].equals(this.attributes[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

