/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

import csbase.logic.ClientProjectFile;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

class ClientProjectFileList
implements Serializable,
Iterable<ClientProjectFile> {
    private List<ClientProjectFile> children;
    private ClientProjectFile parent;

    ClientProjectFileList(ClientProjectFile parent) {
        this.parent = parent;
        this.children = new ArrayList<ClientProjectFile>();
    }

    void addIfDoesntExist(boolean clientSide, boolean fixParentsRecursively, ClientProjectFile ... newChildren) {
        if (!this.prepareNewChildren(clientSide, fixParentsRecursively, newChildren)) {
            return;
        }
        ClientProjectFile[] clientProjectFileArray = newChildren;
        int n = newChildren.length;
        int n2 = 0;
        while (n2 < n) {
            ClientProjectFile child = clientProjectFileArray[n2];
            if (!this.children.contains(child)) {
                this._add(child, false);
            }
            ++n2;
        }
        this.sort();
    }

    void add(boolean clientSide, boolean fixParentsRecursively, ClientProjectFile ... newChildren) {
        if (!this.prepareNewChildren(clientSide, fixParentsRecursively, newChildren)) {
            return;
        }
        ClientProjectFile[] clientProjectFileArray = newChildren;
        int n = newChildren.length;
        int n2 = 0;
        while (n2 < n) {
            ClientProjectFile child = clientProjectFileArray[n2];
            this._add(child, false);
            ++n2;
        }
        this.sort();
    }

    private void sort() {
        Collections.sort(this.children);
    }

    private boolean prepareNewChildren(boolean clientSide, boolean fixParentsRecursively, ClientProjectFile ... newChildren) {
        if (newChildren == null) {
            return false;
        }
        if (clientSide) {
            ClientProjectFileList.setParents(fixParentsRecursively, this.parent, newChildren);
        }
        return true;
    }

    private void _add(ClientProjectFile child, boolean sort) {
        this.children.add(child);
        if (sort) {
            this.sort();
        }
    }

    int remove(ClientProjectFile child) {
        int i = this.children.indexOf(child);
        if (i != -1) {
            this.children.remove(i);
        }
        return i;
    }

    ClientProjectFile[] toArray() {
        return this.children.toArray(new ClientProjectFile[this.children.size()]);
    }

    private static void setParents(boolean recursive, ClientProjectFile parent, ClientProjectFileList children) {
        if (children == null) {
            return;
        }
        for (ClientProjectFile child : children) {
            ClientProjectFileList.setParent(recursive, parent, child);
        }
    }

    private static void setParents(boolean recursive, ClientProjectFile parent, ClientProjectFile ... children) {
        ClientProjectFile[] clientProjectFileArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            ClientProjectFile child = clientProjectFileArray[n2];
            ClientProjectFileList.setParent(recursive, parent, child);
            ++n2;
        }
    }

    private static void setParent(boolean recursive, ClientProjectFile parent, ClientProjectFile child) {
        child.setParent(parent);
        if (recursive && child.isDirectory()) {
            ClientProjectFileList.setParents(recursive, child, child.getChildrenList());
        }
    }

    @Override
    public Iterator<ClientProjectFile> iterator() {
        return this.children.iterator();
    }

    void setParent(ClientProjectFile newParent) {
        for (ClientProjectFile child : this.children) {
            child.setParent(newParent);
        }
        this.parent = newParent;
    }
}

