/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

import csbase.exception.project.FileLockedException;
import csbase.logic.ClientFile;
import csbase.logic.ClientFileType;
import csbase.logic.ProjectFileType;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.SGAServiceInterface;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.LinkedList;
import java.util.List;
import tecgraf.javautils.core.io.FileUtils;

public class ClientSGAFile
implements ClientFile,
Serializable {
    private ClientSGAFile parent;
    private String sgaName;
    private String path;
    private boolean isDir;
    private String separator;
    private boolean canRead;
    private boolean canWrite;
    private boolean canExecute;
    private long size;
    private String linkPath;
    private boolean isSymbolicLink;
    private List<ClientSGAFile> brothers;

    public ClientSGAFile(String sgaName) {
        this(null, sgaName, "/");
    }

    public ClientSGAFile(String sgaName, String path) {
        this(null, sgaName, path);
    }

    private ClientSGAFile(ClientSGAFile parent, String sgaName, String path) {
        if (sgaName == null) {
            throw new IllegalArgumentException("Nome do SGA n\u00e3o pode ser nulo.");
        }
        this.parent = parent;
        this.sgaName = sgaName;
        String string = this.path = path == null ? "/" : path;
        if (this.path.equals("/")) {
            this.isDir = true;
        }
        this.separator = "/";
        this.canRead = true;
        this.canWrite = true;
        this.canExecute = true;
        this.size = 0L;
        this.linkPath = "";
        this.isSymbolicLink = false;
        this.brothers = new LinkedList<ClientSGAFile>();
    }

    public String getSGAName() {
        return this.sgaName;
    }

    public boolean isDir() {
        return this.isDir;
    }

    public void setDir(boolean isDir) {
        this.isDir = isDir;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setCanRead(boolean canRead) {
        this.canRead = canRead;
    }

    public void setCanWrite(boolean canWrite) {
        this.canWrite = canWrite;
    }

    public void setCanExecute(boolean canExecute) {
        this.canExecute = canExecute;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getLinkPath() {
        return this.linkPath;
    }

    public boolean isSymbolicLink() {
        return this.isSymbolicLink;
    }

    public void setLinkPath(String linkPath) {
        this.linkPath = linkPath;
    }

    public void setSymbolicLink(boolean isSymbolicLink) {
        this.isSymbolicLink = isSymbolicLink;
    }

    public List<ClientSGAFile> getBrothers() {
        return this.brothers;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.sgaName == null ? 0 : this.sgaName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClientSGAFile other = (ClientSGAFile)obj;
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        return !(this.sgaName == null ? other.sgaName != null : !this.sgaName.equals(other.sgaName));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("(sga=");
        builder.append(this.sgaName);
        builder.append(",path=");
        builder.append(this.path);
        builder.append(")");
        return builder.toString();
    }

    @Override
    public boolean canRead() {
        return this.canRead;
    }

    @Override
    public boolean canWrite() {
        return this.canWrite;
    }

    @Override
    public boolean canExecute() {
        return this.canExecute;
    }

    @Override
    public boolean exists() throws IOException {
        SGAServiceInterface sgaService = ClientRemoteLocator.sgaService;
        ClientSGAFile file = sgaService.getFile(this.sgaName, this.path);
        return file != null;
    }

    @Override
    public ClientFile[] getChildren() throws Exception {
        SGAServiceInterface sgaService = ClientRemoteLocator.sgaService;
        List<ClientSGAFile> children = sgaService.getChildren(this.sgaName, this.path);
        if (children == null) {
            throw new IOException("A opera\u00e7\u00e3o n\u00e3o foi feita porque o SGA n\u00e3o est\u00e1 dispon\u00edvel.");
        }
        ClientFile[] result = new ClientFile[children.size()];
        int i = 0;
        while (i < children.size()) {
            ClientSGAFile child = children.get(i);
            child.setParent(this);
            result[i] = child;
            ++i;
        }
        return result;
    }

    @Override
    public ClientFileType getClientFileType() {
        return ClientFileType.SGA;
    }

    @Override
    public String getName() {
        String[] splited = FileUtils.splitPath((String)this.path, (String)this.separator);
        int length = splited.length;
        if (length <= 0) {
            return this.path;
        }
        return splited[length - 1];
    }

    @Override
    public ClientFile getParent() {
        if (this.parent != null) {
            return this.parent;
        }
        if ("/".equals(this.path) || this.path.isEmpty()) {
            return null;
        }
        try {
            int i = this.path.substring(0, this.path.length() - 1).lastIndexOf(this.separator);
            if (i != -1) {
                String parentPath = this.path.substring(0, i + 1);
                SGAServiceInterface sgaService = ClientRemoteLocator.sgaService;
                ClientSGAFile parentFile = sgaService.getFile(this.sgaName, parentPath);
                return parentFile;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public String[] getPath() {
        String[] splited = FileUtils.splitPath((String)this.path, (String)this.separator);
        return splited;
    }

    @Override
    public String getStringPath() {
        return this.path;
    }

    @Override
    public String getType() {
        String fileExtension = FileUtils.getFileExtension((String)this.getName());
        ProjectFileType pft = ProjectFileType.getProjectFileTypeFromExtension(fileExtension);
        if (pft == null) {
            return "UNKNOWN";
        }
        return pft.getCode();
    }

    @Override
    public boolean isDirectory() {
        return this.isDir;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public long getModificationDate() {
        return 0L;
    }

    private void setParent(ClientSGAFile parent) {
        this.parent = parent;
    }

    @Override
    public void close(boolean force) throws IOException {
        throw new UnsupportedOperationException("Opera\u00e7\u00e3o de fechar arquivo do SGA n\u00e3o est\u00e1 dispon\u00edvel.");
    }

    @Override
    public InputStream getInputStream() throws IOException {
        throw new UnsupportedOperationException("Opera\u00e7\u00e3o de leitura do arquivo do SGA n\u00e3o est\u00e1 dispon\u00edvel.");
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        throw new UnsupportedOperationException("Opera\u00e7\u00e3o de escrita de um arquivo do SGA n\u00e3o est\u00e1 dispon\u00edvel.");
    }

    @Override
    public void open(boolean readOnly) throws Exception {
        throw new UnsupportedOperationException("Opera\u00e7\u00e3o de leitura de um arquivo do SGA n\u00e3o est\u00e1 dispon\u00edvel.");
    }

    @Override
    public long position() throws IOException {
        throw new UnsupportedOperationException("Opera\u00e7\u00e3o de leitura de um arquivo do SGA n\u00e3o est\u00e1 dispon\u00edvel.");
    }

    @Override
    public void position(long newPosition) throws IOException {
        throw new UnsupportedOperationException("Opera\u00e7\u00e3o de leitura de um arquivo do SGA n\u00e3o est\u00e1 dispon\u00edvel.");
    }

    @Override
    public int read(byte[] dst, long position) throws Exception {
        throw new UnsupportedOperationException("Opera\u00e7\u00e3o de leitura de um arquivo do SGA n\u00e3o est\u00e1 dispon\u00edvel.");
    }

    @Override
    public int read(byte[] dst, int off, int len, long position) throws Exception {
        throw new UnsupportedOperationException("Opera\u00e7\u00e3o de leitura de um arquivo do SGA n\u00e3o est\u00e1 dispon\u00edvel.");
    }

    @Override
    public void write(byte[] src, int off, int len, long position) throws IOException, FileLockedException {
        throw new UnsupportedOperationException("Opera\u00e7\u00e3o de escrita de um arquivo do SGA n\u00e3o est\u00e1 dispon\u00edvel.");
    }

    @Override
    public void write(byte[] src, long position) throws IOException, FileLockedException {
        throw new UnsupportedOperationException("Opera\u00e7\u00e3o de escrita de um arquivo do SGA n\u00e3o est\u00e1 dispon\u00edvel.");
    }
}

