/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

import csbase.logic.CommandFinalizationInfo;
import csbase.logic.CommandNotification;

public abstract class ExtendedCommandFinishedNotification
extends CommandNotification {
    protected Integer elapsedTimeSec;
    protected Integer userTimeSec;
    protected Integer cpuTimeSec;
    protected long endTime;

    public ExtendedCommandFinishedNotification(String sender, Object commandId, String cmdDesc, String tip, Integer elapsedTimeSec, Integer userTimeSec, Integer cpuTimeSec, long startTime, long endTime, String execHost, Object projectId, CommandFinalizationInfo finalizationInfo) {
        super(sender, commandId, cmdDesc, tip, startTime, execHost, projectId, finalizationInfo);
        this.endTime = endTime;
        this.setElapsedTime(elapsedTimeSec);
        this.setUserTime(userTimeSec);
        this.setCpuTime(cpuTimeSec);
    }

    @Override
    public String toString() {
        String msg = "CMD/" + this.getStatusString() + " (" + this.cmdDesc + ") (" + this.getTip() + ")" + " - " + this.commandId + " : ";
        msg = this.finalizationInfo.getExitCode() != null ? String.valueOf(msg) + "c\u00f3digo de sa\u00edda " + this.finalizationInfo.getExitCode() + ", " : String.valueOf(msg) + "c\u00f3digo de sa\u00edda <n\u00e3o informado>, ";
        msg = this.userTimeSec != null ? String.valueOf(msg) + "user " + this.userTimeSec + " s, " : String.valueOf(msg) + "user <n\u00e3o informado>, ";
        msg = this.cpuTimeSec != null ? String.valueOf(msg) + "cpu " + this.cpuTimeSec + " s, " : String.valueOf(msg) + "cpu <n\u00e3o informado>, ";
        msg = this.elapsedTimeSec != null ? String.valueOf(msg) + "total " + this.elapsedTimeSec + " s." : String.valueOf(msg) + "total <n\u00e3o informado>.";
        msg = String.valueOf(msg) + "\n";
        msg = this.startTime >= 0L ? String.valueOf(msg) + "hora de in\u00edcio " + this.startTime + "." : String.valueOf(msg) + "hora de in\u00edcio <n\u00e3o informado>.";
        msg = this.endTime >= 0L ? String.valueOf(msg) + "hora de t\u00e9rmino " + this.endTime + "." : String.valueOf(msg) + "hora de t\u00e9rmino <n\u00e3o informado>.";
        msg = this.execHost != null && !this.execHost.equals("") ? String.valueOf(msg) + "executado por " + this.execHost + "." : String.valueOf(msg) + "executado por <n\u00e3o informado>.";
        return msg;
    }

    public Integer getElapsedTime() {
        return this.elapsedTimeSec;
    }

    public Integer getUserTime() {
        return this.userTimeSec;
    }

    public Integer getCPUTime() {
        return this.cpuTimeSec;
    }

    public long getEndTime() {
        return this.endTime;
    }

    private void setElapsedTime(Integer elapsedTime) {
        if (elapsedTime != null && elapsedTime < 0) {
            throw new IllegalArgumentException("elapsedTime < 0 ");
        }
        this.elapsedTimeSec = elapsedTime;
    }

    private void setUserTime(Integer userTime) {
        if (userTime != null && userTime < 0) {
            throw new IllegalArgumentException("userTime < 0 ");
        }
        this.userTimeSec = userTime;
    }

    private void setCpuTime(Integer cpuTime) {
        if (cpuTime != null && cpuTime < 0) {
            throw new IllegalArgumentException("cpuTime < 0 ");
        }
        this.cpuTimeSec = cpuTime;
    }
}

