/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

import csbase.logic.ClientProjectFile;
import csbase.logic.NewProjectFileEvent;
import csbase.logic.ProjectEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Observable;
import java.util.Observer;

class NewDirPathObserver
implements Observer {
    private List<ClientProjectFile> newDirList;
    private final ClientProjectFile parentDir;
    private final Collection<String> names;

    public NewDirPathObserver(ClientProjectFile parentDir, String[] names) {
        this.parentDir = parentDir;
        this.names = Arrays.asList(names);
        this.newDirList = new ArrayList<ClientProjectFile>();
        this.newDirList.add(parentDir);
    }

    @Override
    public void update(Observable observable, Object arg) {
        ProjectEvent action = (ProjectEvent)arg;
        if (action == null) {
            return;
        }
        switch (action.event) {
            case 3: {
                NewProjectFileEvent event = (NewProjectFileEvent)action;
                ClientProjectFile file = event.getFile();
                if (file == null) {
                    return;
                }
                if (!(file.getParent().equals(this.parentDir) || this.names.contains(file.getName()) || this.names.contains(file.getParent().getName()))) {
                    return;
                }
                this.addDirListAndNotify(file);
                break;
            }
            default: {
                return;
            }
        }
    }

    private synchronized void addDirListAndNotify(ClientProjectFile dir) {
        if (!this.newDirList.contains(dir.getParent())) {
            this.newDirList.add(dir.getParent());
        }
        this.newDirList.add(dir);
        if (this.newDirList.size() == this.names.size()) {
            this.notify();
        }
    }

    public synchronized void verifyAndWaitUntilDirPathCreated() {
        while (this.newDirList.size() != this.names.size()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

