/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

import csbase.logic.ClientProjectFile;
import csbase.logic.NewProjectFileEvent;
import csbase.logic.NewProjectFilesEvent;
import csbase.logic.ProjectEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Observable;
import java.util.Observer;

class NewFileObserver
implements Observer {
    private ClientProjectFile[] newFiles;
    private final ClientProjectFile parentDir;
    private final Collection<String> names;

    public NewFileObserver(ClientProjectFile parentDir, String[] names) {
        this.parentDir = parentDir;
        this.names = Arrays.asList(names);
    }

    @Override
    public void update(Observable observable, Object arg) {
        ProjectEvent action = (ProjectEvent)arg;
        if (action == null) {
            return;
        }
        switch (action.event) {
            case 3: {
                NewProjectFileEvent event = (NewProjectFileEvent)action;
                ClientProjectFile file = event.getFile();
                if (file == null) {
                    return;
                }
                String[] path = event.getPath();
                if (path == null) {
                    return;
                }
                if (!NewFileObserver.pathEquals(path, this.parentDir.getPath()) || !this.names.contains(file.getName())) {
                    return;
                }
                this.setNewFiles(new ClientProjectFile[]{file});
                break;
            }
            case 11: {
                NewProjectFilesEvent event = (NewProjectFilesEvent)action;
                ClientProjectFile[] files = event.getFiles();
                if (files == null || files.length == 0) {
                    return;
                }
                String[][] paths = event.getPaths();
                if (paths.length != files.length) {
                    return;
                }
                int i = 0;
                while (i < files.length) {
                    if (!this.checkPath(paths[i], this.parentDir.getPath()) || !this.names.contains(files[i].getName())) {
                        return;
                    }
                    ++i;
                }
                this.setNewFiles(files);
                break;
            }
            default: {
                return;
            }
        }
    }

    private boolean checkPath(String[] pathToCheck, String[] referencePath) {
        if (pathToCheck.length < referencePath.length) {
            return false;
        }
        int i = 0;
        while (i < referencePath.length) {
            if (!pathToCheck[i].equals(referencePath[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private synchronized void setNewFiles(ClientProjectFile[] files) {
        this.newFiles = files;
        this.notify();
    }

    public synchronized ClientProjectFile[] getNewFiles() {
        while (this.newFiles == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.newFiles;
    }

    private static final boolean pathEquals(String[] path1, String[] path2) {
        if (path1 == null && path2 == null) {
            return true;
        }
        if (path1 == null || path2 == null) {
            return false;
        }
        if (path1.length != path2.length) {
            return false;
        }
        int inx = 0;
        while (inx < path1.length) {
            if (!path1[inx].equals(path2[inx])) {
                return false;
            }
            ++inx;
        }
        return true;
    }
}

