/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

import csbase.logic.AdministrationEvent;
import csbase.logic.ProjectAllocationState;
import csbase.logic.UserProjectInfo;
import csbase.remote.ClientRemoteLocator;
import csbase.util.restart.RestartListener;
import csbase.util.restart.RestartManager;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Observable;

public class ProjectAdminInfo
extends UserProjectInfo {
    private static Observable observable = new Observable(){

        @Override
        public void notifyObservers(Object arg) {
            this.setChanged();
            super.notifyObservers(arg);
        }
    };
    private String absolutePath;
    private long areaRequestSize;
    private Date areaRequestDate;
    private long areaLockedSize;
    private ProjectAllocationState state;

    static {
        RestartManager.getInstance().addListener(new RestartListener(){

            public void restart() {
                observable.deleteObservers();
            }
        });
    }

    public static ProjectAdminInfo[] getAll() throws RemoteException {
        return ClientRemoteLocator.projectService.getLockedProjectAdminInfo();
    }

    public static void allocateAreaForProjects(ProjectAdminInfo[] infos) throws RemoteException {
        ClientRemoteLocator.projectService.unlockProjectsWithAllocation(infos);
    }

    public static void freeAreaForProjects(ProjectAdminInfo[] infos) throws RemoteException {
        ClientRemoteLocator.projectService.freeAreaForProjects(infos);
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    public long getAreaRequestSize() {
        return this.areaRequestSize;
    }

    public long getAreaLockedSize() {
        return this.areaLockedSize;
    }

    public ProjectAllocationState getState() {
        return this.state;
    }

    public boolean isLocked() {
        return this.state == ProjectAllocationState.WAITING_AREA_ALLOCATION;
    }

    public boolean isUnlockedWithAreaAllocated() {
        return this.state == ProjectAllocationState.UNLOCKED_WITH_AREA_ALLOCATED;
    }

    public boolean isWaitingAreaFree() {
        return this.state == ProjectAllocationState.WAITING_AREA_FREE;
    }

    public Date getAreaRequestDate() {
        return this.areaRequestDate;
    }

    public void setState(ProjectAllocationState state) {
        this.state = state;
    }

    public void setAreaRequestSize(long size) {
        this.areaRequestSize = size;
    }

    public void setAreaLockedSize(long size) {
        this.areaLockedSize = size;
    }

    public void setAreaRequestDate(Date date) {
        this.areaRequestDate = date;
    }

    public static void update(AdministrationEvent action) {
        observable.notifyObservers(action);
    }

    public ProjectAdminInfo(Object projectId, String projectName, Object ownerId, String absolutePath, ProjectAllocationState state) {
        super(projectId, projectName, ownerId);
        this.absolutePath = absolutePath;
        this.state = state;
        this.areaRequestSize = 0L;
        this.areaRequestDate = null;
    }
}

