/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

import csbase.logic.ClientProjectFile;
import csbase.logic.CommonProjectInfo;
import csbase.logic.DirRefreshedEvent;
import csbase.logic.NewProjectFileEvent;
import csbase.logic.NewProjectFilesEvent;
import csbase.logic.ProjectClosedEvent;
import csbase.logic.ProjectDeletedEvent;
import csbase.logic.ProjectFileDeletedEvent;
import csbase.logic.ProjectFileRenamedEvent;
import csbase.logic.ProjectFileStateChangedEvent;
import csbase.logic.ProjectFilesDeletedEvent;
import csbase.logic.ProjectInfoModifiedEvent;
import csbase.logic.TreeChangedEvent;
import csbase.remote.RemoteEvent;

public abstract class ProjectEvent
extends RemoteEvent {
    public static final int INFO_MODIFIED = 1;
    public static final int PROJECT_DELETED = 2;
    public static final int NEW_FILE = 3;
    public static final int FILE_DELETED = 4;
    public static final int NEW_FILE_NAME = 5;
    public static final int FILE_MOVED = 6;
    public static final int FILE_STATE_CHANGED = 7;
    public static final int TREE_CHANGED = 8;
    public static final int PROJECT_CLOSED = 9;
    public static final int FILES_DELETED = 10;
    public static final int NEW_FILES = 11;
    public static final int DIR_REFRESHED = 12;
    public int event;
    public Object projectId;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ProjectEvent makeEvent(Object projectId, int type, Object[] args) {
        try {
            switch (type) {
                case 1: {
                    return new ProjectInfoModifiedEvent(projectId, (CommonProjectInfo)args[0]);
                }
                case 2: {
                    return new ProjectDeletedEvent(args[0]);
                }
                case 3: {
                    return new NewProjectFileEvent(projectId, (String[])args[0], (ClientProjectFile)args[1]);
                }
                case 11: {
                    return new NewProjectFilesEvent(projectId, (String[][])args[0], (ClientProjectFile[])args[1]);
                }
                case 4: {
                    return new ProjectFileDeletedEvent(projectId, (String[])args[0]);
                }
                case 5: {
                    return new ProjectFileRenamedEvent(projectId, (String[])args[0], (String)args[1], (String)args[2]);
                }
                case 6: {
                    return null;
                }
                case 7: {
                    return new ProjectFileStateChangedEvent(projectId, (String[])args[0], (String)args[1], (Boolean)args[2], (Long)args[3], (Long)args[4], (Boolean)args[5]);
                }
                case 8: {
                    return new TreeChangedEvent(projectId, (ClientProjectFile)args[0]);
                }
                case 12: {
                    return new DirRefreshedEvent(projectId, (String[])args[0], (ClientProjectFile)args[1]);
                }
                case 9: {
                    return new ProjectClosedEvent(projectId);
                }
                case 10: {
                    return new ProjectFilesDeletedEvent(projectId, (String[][])args[0]);
                }
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

