/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

import csbase.logic.ProjectFileTypeInfo;
import csbase.remote.ClientRemoteLocator;
import csbase.util.StringUtils;
import csbase.util.restart.RestartListener;
import csbase.util.restart.RestartManager;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ProjectFileType
implements Serializable,
Comparable<ProjectFileType> {
    public static final String DIRECTORY_TYPE = "DIRECTORY_TYPE";
    public static final String UNKNOWN = "UNKNOWN";
    private static Map<String, ProjectFileType> fileTypes;
    private static ProjectFileType[] fileTypesToArray;
    protected static ProjectFileType projectFileTypePrototype;
    private String description;
    private List<String> extensions;
    private String mimeType;
    private String typeCode;

    static {
        RestartManager.getInstance().addListener(new RestartListener(){

            public void restart() {
                fileTypes = null;
                fileTypesToArray = null;
            }
        });
        projectFileTypePrototype = new ProjectFileType();
    }

    @Override
    public int compareTo(ProjectFileType fileType) {
        if (this.description == null) {
            return -1;
        }
        if (fileType == null) {
            return -1;
        }
        String desc = fileType.getDescription();
        if (desc == null) {
            return -1;
        }
        return StringUtils.compare((String)this.description, (String)desc);
    }

    protected ProjectFileType createProjectFileType(ProjectFileTypeInfo info) {
        return new ProjectFileType(info);
    }

    public String getCode() {
        return this.typeCode;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getExtensions() {
        return Collections.unmodifiableList(this.extensions);
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String toString() {
        return this.description;
    }

    protected ProjectFileType() {
    }

    public ProjectFileType(ProjectFileTypeInfo info) {
        this.typeCode = info.typeCode;
        this.description = info.description;
        this.mimeType = info.mimeType;
        this.extensions = new ArrayList<String>();
        if (info.extensions != null) {
            this.extensions.addAll(info.extensions);
        }
    }

    public static ProjectFileType[] getAllFileTypes() {
        return fileTypesToArray;
    }

    public static ProjectFileType getUnknownFileType() {
        return fileTypes.get(UNKNOWN);
    }

    public static ProjectFileType getFileType(String typeCode) {
        ProjectFileType type = null;
        if (fileTypes == null) {
            ProjectFileTypeInfo info;
            try {
                info = ClientRemoteLocator.projectService.getFileType(typeCode);
            }
            catch (Exception e) {
                return null;
            }
            type = info != null ? projectFileTypePrototype.createProjectFileType(info) : null;
        } else {
            type = fileTypes.get(typeCode);
            if (type == null) {
                type = fileTypes.get(UNKNOWN);
            }
        }
        return type;
    }

    public static ProjectFileType getProjectFileTypeFromExtension(String extension) {
        if (extension == null) {
            return null;
        }
        ProjectFileType[] projectFileTypeArray = fileTypesToArray;
        int n = fileTypesToArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProjectFileType pft = projectFileTypeArray[n2];
            List<String> exts = pft.getExtensions();
            for (String ext : exts) {
                if (!extension.equalsIgnoreCase(ext)) continue;
                return pft;
            }
            ++n2;
        }
        return null;
    }

    public static void loadFileTypes(Locale locale) throws RemoteException {
        if (fileTypes != null) {
            return;
        }
        fileTypes = new HashMap<String, ProjectFileType>();
        Hashtable<String, ProjectFileTypeInfo> fileTypesInfo = ClientRemoteLocator.projectService.getAllFileTypes(locale);
        fileTypesToArray = new ProjectFileType[fileTypesInfo.size()];
        int i = 0;
        for (ProjectFileTypeInfo info : fileTypesInfo.values()) {
            ProjectFileType pft = projectFileTypePrototype.createProjectFileType(info);
            fileTypes.put(info.typeCode, pft);
            ProjectFileType.fileTypesToArray[i++] = pft;
        }
        if (fileTypesToArray.length > 0) {
            Arrays.sort(fileTypesToArray);
        }
    }

    static /* synthetic */ Map access$1() {
        return fileTypes;
    }

    static /* synthetic */ ProjectFileType[] access$3() {
        return fileTypesToArray;
    }
}

