/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

import csbase.exception.administration.AdministrationDeleteException;
import csbase.logic.AdministrationEvent;
import csbase.logic.AttributesPermission;
import csbase.logic.ChoicePermission;
import csbase.logic.GlobalAdminPermission;
import csbase.logic.Permission;
import csbase.logic.Role;
import csbase.logic.UserInfo;
import csbase.logic.UserOutline;
import csbase.remote.ClientRemoteLocator;
import csbase.util.restart.RestartListener;
import csbase.util.restart.RestartManager;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.ImageIcon;

public class User
implements Serializable {
    public static final String LOGIN = "login";
    public static final String SUPER_USER_LOGIN = "superuserlogin";
    public static final String NAME = "name";
    public static final String EMAILS = "emails";
    public static final String ROLE_IDS = "roleIds";
    public static final String PERMISSION_IDS = "permissionIds";
    public static final String PASSWORD = "password";
    public static final String PASSWORD_DIGEST = "passwordDigest";
    public static final String LAST_UPDATE = "lastUpdate";
    public static final String FORCE_LOCAL_LOGIN = "forceLocalLogin";
    public static String USER_GROUP = "userGroup";
    public static final String CREATION_DATE = "creationDate";
    private static final Hashtable<String, User> _USERS = new Hashtable();
    private static final Lock _LOAD_USERS_LOCK = new ReentrantLock();
    private static final String ADMIN_LOGIN = "admin";
    private static User loggedUser = null;
    private static boolean hasAllUsers = false;
    private final Object id;
    private final UserInfo info;
    private transient Object key;
    private static Observable observable = new Observable(){

        @Override
        public void notifyObservers(Object arg) {
            this.setChanged();
            super.notifyObservers(arg);
        }
    };

    static {
        RestartManager.getInstance().addListener(new RestartListener(){

            public void restart() {
                _USERS.clear();
                hasAllUsers = false;
                observable.deleteObservers();
            }
        });
    }

    public User(Object id, UserInfo info) {
        this.id = id;
        this.info = info;
    }

    public static synchronized void registerLogin(Object key, User user) {
        loggedUser = user;
        loggedUser.setKey(key);
    }

    public static synchronized void registerLogout() {
        loggedUser = null;
    }

    public static synchronized User getLoggedUser() {
        return loggedUser;
    }

    public void setKey(Object key) {
        this.key = key;
    }

    public Object getKey() {
        return this.key;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof User)) {
            return false;
        }
        User user = (User)obj;
        return user.getId().equals(this.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public static User getUser(Object id) throws RemoteException {
        if (id == null) {
            return null;
        }
        User.loadLocalUsersCache();
        String key = User.createKeyForLocalUsersCache(id);
        User user = _USERS.get(key);
        if (user == null && (user = ClientRemoteLocator.administrationService.getUser(id)) != null) {
            _USERS.put(key, user);
        }
        return user;
    }

    public static User getUserByLogin(String login) throws Exception {
        return User.getUser(login);
    }

    public static List<UserOutline> getAllOutlines() throws Exception {
        if (hasAllUsers) {
            return User.usersToOutlines();
        }
        return ClientRemoteLocator.administrationService.getAllUserOutlines();
    }

    public static Vector<UserOutline> getOutlines(Object[] userIds) throws Exception {
        Vector<UserOutline> outlines = new Vector<UserOutline>();
        if (userIds == null) {
            return outlines;
        }
        int i = 0;
        while (i < userIds.length) {
            User user = User.getUser(userIds[i]);
            if (user != null) {
                outlines.add(user.getOutline());
            }
            ++i;
        }
        return outlines;
    }

    public static List<User> getAllUsers() throws RemoteException {
        User.loadLocalUsersCache();
        return User.usersToVector();
    }

    public static int getNumRegisteredUsers() throws RemoteException {
        User.loadLocalUsersCache();
        return _USERS.size();
    }

    private static void loadLocalUsersCache() throws RemoteException {
        if (hasAllUsers) {
            return;
        }
        _LOAD_USERS_LOCK.lock();
        try {
            List<User> allUsers = ClientRemoteLocator.administrationService.getAllUsers();
            if (allUsers == null) {
                return;
            }
            _USERS.clear();
            for (User user : allUsers) {
                String key = User.createKeyForLocalUsersCache(user.getId());
                _USERS.put(key, user);
            }
            hasAllUsers = true;
        }
        finally {
            _LOAD_USERS_LOCK.unlock();
        }
    }

    public static String getName(Object id) throws Exception {
        User user = User.getUser(id);
        if (user != null) {
            return user.getName();
        }
        return null;
    }

    public void addRole(Role role) throws Exception {
        if (this.isAdmin()) {
            return;
        }
        Object[] roles = this.getRoleIds();
        ArrayList<Object> newRoles = new ArrayList<Object>();
        int i = 0;
        while (i < roles.length) {
            if (roles[i].equals(role.getId())) {
                return;
            }
            newRoles.add(roles[i]);
            ++i;
        }
        newRoles.add(role.getId());
        this.setRoleIds(newRoles.toArray());
    }

    public void removeRole(Role role) throws Exception {
        Object[] roles = this.getRoleIds();
        ArrayList<Object> newRoles = new ArrayList<Object>();
        int i = 0;
        while (i < roles.length) {
            if (!roles[i].equals(role.getId())) {
                newRoles.add(roles[i]);
            }
            ++i;
        }
        this.setRoleIds(newRoles.toArray());
    }

    public void addPermission(Permission permission) throws Exception {
        if (this.isAdmin()) {
            return;
        }
        Object[] permissions = this.getPermissionIds();
        ArrayList<Object> newPermissions = new ArrayList<Object>();
        int i = 0;
        while (i < permissions.length) {
            if (permissions[i].equals(permission.getId())) {
                return;
            }
            newPermissions.add(permissions[i]);
            ++i;
        }
        newPermissions.add(permission.getId());
        this.setPermissionIds(newPermissions.toArray());
    }

    public void removePermission(Permission permission) throws Exception {
        Object[] permissions = this.getPermissionIds();
        ArrayList<Object> newPermissions = new ArrayList<Object>();
        int i = 0;
        while (i < permissions.length) {
            if (!permissions[i].equals(permission.getId())) {
                newPermissions.add(permissions[i]);
            }
            ++i;
        }
        this.setPermissionIds(newPermissions.toArray());
    }

    public static User[] getAdmins() throws Exception {
        Vector<User> users = new Vector<User>();
        users.add(User.getUserByLogin((String)User.getAdminId()));
        for (User user : User.getAllUsers()) {
            if (user.getPermission(GlobalAdminPermission.class) == null) continue;
            users.add(user);
        }
        return users.toArray(new User[0]);
    }

    public static List<Object> getAdminIds() throws Exception {
        LinkedList<Object> users = new LinkedList<Object>();
        users.add(User.getAdminId());
        for (User user : User.getAllUsers()) {
            if (user.getPermission(GlobalAdminPermission.class) == null) continue;
            users.add(user.getId());
        }
        return users;
    }

    public static Object getAdminId() {
        return ADMIN_LOGIN;
    }

    public static User createUser(UserInfo info) throws Exception {
        if (info.getLogin() == null || info.getLogin().equals("")) {
            throw new Exception("login n\u00e3o pode ser vazio");
        }
        if (User.getUserByLogin(info.getLogin()) != null) {
            return null;
        }
        User user = ClientRemoteLocator.administrationService.createUser(info);
        if (user != null) {
            String key = User.createKeyForLocalUsersCache(user.getId());
            _USERS.put(key, user);
        }
        return user;
    }

    public static ImageIcon getPhoto(Object id) {
        try {
            return ClientRemoteLocator.administrationService.getPhoto(id);
        }
        catch (Exception e1) {
            try {
                return ClientRemoteLocator.administrationService.getPhoto(null);
            }
            catch (Exception e2) {
                return null;
            }
        }
    }

    public static User modifyUser(Object id, UserInfo info) throws Exception {
        User user = User.getUser(id);
        if (user == null) {
            return null;
        }
        if (!user.getLogin().equals(info.getLogin())) {
            return null;
        }
        user = ClientRemoteLocator.administrationService.modifyUser(id, info);
        String key = User.createKeyForLocalUsersCache(id);
        _USERS.put(key, user);
        return user;
    }

    public static void deleteUser(Object id) throws Exception, AdministrationDeleteException {
        ClientRemoteLocator.administrationService.deleteUser(id);
        String key = User.createKeyForLocalUsersCache(id);
        _USERS.remove(key);
    }

    public static void addObserver(Observer o) {
        observable.addObserver(o);
    }

    public static void deleteObserver(Observer o) {
        observable.deleteObserver(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(AdministrationEvent event) throws Exception {
        User user = (User)event.item;
        Object id = user.getId();
        String key = User.createKeyForLocalUsersCache(id);
        switch (event.type) {
            case 1: 
            case 2: {
                _USERS.put(key, user);
                Class<User> clazz = User.class;
                synchronized (User.class) {
                    if (loggedUser != null && id.equals(loggedUser.getId())) {
                        user.setKey(loggedUser.getKey());
                        loggedUser = user;
                    }
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    break;
                }
            }
            case 3: {
                _USERS.remove(key);
            }
        }
        {
            observable.notifyObservers(new AdministrationEvent(event.type, user.getOutline()));
            return;
        }
    }

    private static List<UserOutline> usersToOutlines() throws Exception {
        ArrayList<UserOutline> list = new ArrayList<UserOutline>();
        for (User user : _USERS.values()) {
            list.add(user.getOutline());
        }
        return list;
    }

    private static List<User> usersToVector() {
        return new ArrayList<User>(_USERS.values());
    }

    public boolean isAdmin() {
        if (this.info.getLogin().equals(ADMIN_LOGIN)) {
            return true;
        }
        return this.getPermission(GlobalAdminPermission.class) != null;
    }

    public static boolean isAdmin(Object uid) {
        User user = null;
        try {
            user = User.getUser(uid);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        if (uid == null || user == null) {
            return false;
        }
        if (ADMIN_LOGIN.equals(uid)) {
            return true;
        }
        return user.getPermission(GlobalAdminPermission.class) != null;
    }

    public Object getAttribute(String attrKey) {
        return this.info.getAttribute(attrKey);
    }

    public Object getId() {
        return this.id;
    }

    public UserOutline getOutline() throws Exception {
        return new UserOutline(this);
    }

    public String getLogin() {
        return this.info.getLogin();
    }

    public String getSuperUserLogin() {
        return (String)this.info.getAttribute(SUPER_USER_LOGIN);
    }

    public String getPasswordDigest() {
        return (String)this.info.getAttribute(PASSWORD_DIGEST);
    }

    public String getName() {
        return (String)this.info.getAttribute(NAME);
    }

    public Date getCreationDate() {
        return (Date)this.info.getAttribute(CREATION_DATE);
    }

    public String[] getEmails() {
        return (String[])this.info.getAttribute(EMAILS);
    }

    public Object[] getRoleIds() {
        return (Object[])this.info.getAttribute(ROLE_IDS);
    }

    public Object[] getPermissionIds() {
        return (Object[])this.info.getAttribute(PERMISSION_IDS);
    }

    public Vector<Object> getAllPermissionIds() throws Exception {
        Object[] roleIds;
        Vector<Object> allPermissionIds = new Vector<Object>();
        Object[] permIds = this.getPermissionIds();
        if (permIds != null) {
            int i = 0;
            while (i < permIds.length) {
                allPermissionIds.add(permIds[i]);
                ++i;
            }
        }
        if ((roleIds = this.getRoleIds()) != null) {
            int i = 0;
            while (i < roleIds.length) {
                Role role = Role.getRole(roleIds[i]);
                Object[] permissionIds = role.getPermissionIds();
                int j = 0;
                while (j < permissionIds.length) {
                    allPermissionIds.add(permissionIds[j]);
                    ++j;
                }
                ++i;
            }
        }
        return allPermissionIds;
    }

    public Role getRole(Object roleId) {
        try {
            Object[] ids = this.getRoleIds();
            int i = 0;
            while (i < ids.length) {
                Role r = Role.getRole(ids[i]);
                if (ids[i].equals(roleId)) {
                    return r;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public <T extends Permission> T getPermission(Class<T> permissionClass) {
        try {
            Vector<Object> ids = this.getAllPermissionIds();
            int i = 0;
            while (i < ids.size()) {
                Permission p = Permission.getPermission(ids.get(i));
                if (p.getClass().equals(permissionClass)) {
                    return (T)((Permission)permissionClass.cast(p));
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public <T extends Permission> T getPermissionAssignableTo(Class<T> permissionClass) {
        try {
            Vector<Object> ids = this.getAllPermissionIds();
            int i = 0;
            while (i < ids.size()) {
                Permission p = Permission.getPermission(ids.get(i));
                if (permissionClass.isAssignableFrom(p.getClass())) {
                    return (T)((Permission)permissionClass.cast(p));
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public Permission getPermission(Object permissionId) {
        try {
            Object[] ids = this.getPermissionIds();
            int i = 0;
            while (i < ids.length) {
                if (ids[i].equals(permissionId)) {
                    return Permission.getPermission(ids[i]);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public AttributesPermission getAttributesPermission(Class<?> permissionClass, String attribute) {
        try {
            Vector<Object> ids = this.getAllPermissionIds();
            int i = 0;
            while (i < ids.size()) {
                AttributesPermission ap;
                Permission p = Permission.getPermission(ids.get(i));
                if (p instanceof AttributesPermission && p.getClass().equals(permissionClass) && (ap = (AttributesPermission)p).hasAttribute(attribute)) {
                    return ap;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public AttributesPermission getMatchAttributesPermission(Class<?> permissionClass, String attribute) throws Exception {
        Vector<Object> ids = this.getAllPermissionIds();
        int i = 0;
        while (i < ids.size()) {
            AttributesPermission ap;
            Permission p = Permission.getPermission(ids.get(i));
            if (p instanceof AttributesPermission && p.getClass().equals(permissionClass) && (ap = (AttributesPermission)p).getMatchAttribute(attribute) != null) {
                return ap;
            }
            ++i;
        }
        return null;
    }

    public AttributesPermission getMatchAttributesPermission(Class<?> permissionClass, String ... attributes) throws Exception {
        if (attributes == null) {
            return null;
        }
        Vector<Object> ids = this.getAllPermissionIds();
        for (Object permissionId : ids) {
            Permission p = Permission.getPermission(permissionId);
            AttributesPermission ap = this.checkClassPermission(p, permissionClass);
            if (ap == null || !this.checkPermissionAttributes(ap, attributes)) continue;
            return ap;
        }
        return null;
    }

    private AttributesPermission checkClassPermission(Permission p, Class<?> permissionClass) {
        if (p instanceof AttributesPermission && p.getClass().equals(permissionClass)) {
            return (AttributesPermission)p;
        }
        return null;
    }

    private boolean checkPermissionAttributes(AttributesPermission ap, String ... attributes) {
        if (attributes == null) {
            return false;
        }
        String[] stringArray = attributes;
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            if (ap.getMatchAttribute(attribute) == null) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasPermission(Class<?> permissionClass, Map<?, ?> attributes) {
        try {
            Vector<Object> ids = this.getAllPermissionIds();
            int i = 0;
            while (true) {
                ChoicePermission cp;
                if (i >= ids.size()) {
                    return false;
                }
                Permission p = Permission.getPermission(ids.get(i));
                if (p instanceof ChoicePermission && p.getClass().equals(permissionClass) && (cp = (ChoicePermission)p).hasPermission(attributes)) {
                    return true;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean hasAnyUserWithPermission(Object permissionId) throws RemoteException {
        List<User> us = User.getAllUsers();
        int i = 0;
        while (i < us.size()) {
            Object[] perms = us.get(i).getPermissionIds();
            if (perms != null) {
                int j = 0;
                while (j < perms.length) {
                    if (permissionId.equals(perms[j])) {
                        return true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }

    public static boolean hasAnyUserWithRole(Object roleId) throws RemoteException {
        List<User> us = User.getAllUsers();
        int i = 0;
        while (i < us.size()) {
            Object[] roles = us.get(i).getRoleIds();
            if (roles != null) {
                int j = 0;
                while (j < roles.length) {
                    if (roleId.equals(roles[j])) {
                        return true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }

    public long getLastUpdate() {
        return (Long)this.info.getAttribute(LAST_UPDATE);
    }

    public UserInfo getUserInfo() {
        return (UserInfo)this.info.clone();
    }

    public void setLogin(String login) {
        this.info.setAttribute(LOGIN, login);
    }

    public void setSuperUserLogin(String login) {
        this.info.setAttribute(SUPER_USER_LOGIN, login);
    }

    public void setName(String name) {
        this.info.setAttribute(NAME, name);
    }

    public void setCreationDate(Date creationDate) {
        this.info.setAttribute(CREATION_DATE, creationDate);
    }

    public void setEmails(String[] emails) {
        this.info.setAttribute(EMAILS, emails);
    }

    public void setRoleIds(Object[] roleIds) {
        this.info.setAttribute(ROLE_IDS, roleIds);
    }

    public void setPermissionIds(Object[] permissionIds) {
        this.info.setAttribute(PERMISSION_IDS, permissionIds);
    }

    public void setPassword(String password) {
        this.info.setAttribute(PASSWORD, password);
    }

    public void setPasswordDigest(String passwordDigest) {
        this.info.setAttribute(PASSWORD_DIGEST, passwordDigest);
    }

    private static String createKeyForLocalUsersCache(Object id) {
        return id.toString().toUpperCase();
    }

    public String toString() {
        String userString = "";
        userString = String.valueOf(userString) + this.info.getLogin();
        userString = String.valueOf(userString) + "\t";
        userString = String.valueOf(userString) + this.getName();
        userString = String.valueOf(userString) + "\t";
        userString = String.valueOf(userString) + Arrays.toString(this.getEmails());
        userString = String.valueOf(userString) + "\t";
        return userString;
    }

    static /* synthetic */ boolean access$1() {
        return hasAllUsers;
    }
}

