/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms;

import csbase.logic.AlgoEvent;
import csbase.logic.IdInterface;
import csbase.logic.algorithms.AlgorithmInfo;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class Category
implements Comparable<Category>,
Serializable,
IdInterface {
    private Category parentCategory;
    private String id;
    private String name;
    private Set<AlgorithmInfo> algorithms = new HashSet<AlgorithmInfo>();
    private SortedSet<Category> categories = new TreeSet<Category>();
    private static Observable observable = new Observable(){

        @Override
        public void notifyObservers(Object arg) {
            this.setChanged();
            super.notifyObservers(arg);
        }
    };

    public Category(Category parentCategory, String id, String name) {
        this.setParentCategory(parentCategory);
        this.setId(id);
        this.setName(name);
    }

    public Category(String id, String name) {
        this.setParentCategory(null);
        this.setId(id);
        this.setName(name);
    }

    public Category(Category category) {
        this(category.getParentCategory(), category.getId(), category.getName());
        this.algorithms = new HashSet<AlgorithmInfo>(category.getAlgorithms());
        this.categories = new TreeSet<Category>(category.getCategories());
    }

    public void updateCategory(Category category) {
        this.name = category.getName();
        this.algorithms = category.getAlgorithms();
        this.categories = category.getCategories();
    }

    public boolean addAlgorithm(AlgorithmInfo algorithm) {
        if (algorithm == null) {
            throw new IllegalArgumentException("algorithm == null");
        }
        return this.algorithms.add(algorithm);
    }

    public boolean addCategory(Category category) {
        if (category == null) {
            throw new IllegalArgumentException("category == null");
        }
        if (this.equals(category)) {
            return false;
        }
        return this.categories.add(category);
    }

    @Override
    public int compareTo(Category other) {
        return this.getName().compareTo(other.getName());
    }

    public boolean containsAlgorithm(AlgorithmInfo algorithm) {
        if (algorithm == null) {
            throw new IllegalArgumentException("algorithm == null");
        }
        return this.algorithms.contains(algorithm);
    }

    public boolean containsAlgorithm(String algoName) {
        for (AlgorithmInfo algoInfo : this.algorithms) {
            if (!algoInfo.getName().equals(algoName)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAlgorithmInChildren(AlgorithmInfo algorithm) {
        if (algorithm == null) {
            throw new IllegalArgumentException("algorithm == null");
        }
        if (this.algorithms.contains(algorithm)) {
            return true;
        }
        for (Category category : this.categories) {
            if (!category.containsAlgorithmInChildren(algorithm)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Category other = (Category)obj;
        return this.getId().equals(other.getId());
    }

    public Set<AlgorithmInfo> getAlgorithms() {
        return this.algorithms;
    }

    public SortedSet<Category> getCategories() {
        return this.categories;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        String fullName = this.getName();
        try {
            Category parentCategory = this.getParentCategory();
            if (parentCategory != null) {
                fullName = this.getParentCategory().getFullName();
                fullName = String.valueOf(fullName) + ":" + this.getName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fullName;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean removeAlgorithm(AlgorithmInfo algorithm) {
        if (algorithm == null) {
            throw new IllegalArgumentException("algorithm == null");
        }
        return this.algorithms.remove(algorithm);
    }

    public void removeAllAlgorithms() {
        this.algorithms.clear();
    }

    public boolean removeCategory(Category category) {
        if (category == null) {
            throw new IllegalArgumentException("category == null");
        }
        return this.categories.remove(category);
    }

    public String toString() {
        return this.name;
    }

    protected void setId(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id == null");
        }
        this.id = id;
    }

    private void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name == null");
        }
        this.name = name;
    }

    public void setParentCategory(Category parentCategory) {
        this.parentCategory = parentCategory;
    }

    public String getParentId() {
        if (this.parentCategory == null) {
            return null;
        }
        return this.parentCategory.getId();
    }

    public Category getParentCategory() {
        return this.parentCategory;
    }

    public static void update(AlgoEvent event) throws Exception {
        observable.notifyObservers(event);
    }

    public static void addObserver(Observer o) {
        observable.addObserver(o);
    }

    public static void deleteObserver(Observer o) {
        observable.deleteObserver(o);
    }

    public boolean containsCategory(String categoryName) {
        for (Category category : this.categories) {
            if (!category.getName().trim().equals(categoryName.trim())) continue;
            return true;
        }
        return false;
    }

    public Category getCategory(String id) {
        if (id == null) {
            return null;
        }
        if (this.id.equals(id)) {
            return this;
        }
        return this.getCategory(id, this.categories);
    }

    private Category getCategory(String id, SortedSet<Category> categories) {
        for (Category category : categories) {
            if (category.getId().equals(id)) {
                return category;
            }
            Category subCategory = this.getCategory(id, category.getCategories());
            if (subCategory == null) continue;
            return subCategory;
        }
        return null;
    }

    public Category getRootCategory() {
        if (this.getParentCategory() == null) {
            return this;
        }
        return this.getRootCategory(this.getParentCategory());
    }

    private Category getRootCategory(Category rootCategory) {
        Category parentCategory = rootCategory.getParentCategory();
        if (parentCategory == null) {
            return rootCategory;
        }
        return this.getRootCategory(parentCategory);
    }

    public void setCategories(SortedSet<Category> categories) {
        this.categories = categories;
    }
}

