/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms;

import csbase.logic.algorithms.CommandLineContext;
import csbase.logic.algorithms.EnvironmentVariable;
import tecgraf.javautils.core.io.FileUtils;

public class CommandLineBuilder {
    public static final String REFERENCE_VAR_CHAR = "$";
    public static final String COMMAND_SEPARATOR = ";";
    public static final String SCRIPT_LINE_SEPARATOR = "\n";
    public static final String SHELL = "/bin/ksh";
    public static final String COMMENT = "# ";
    private final StringBuilder buffer = new StringBuilder();
    private final String lineSeparator;

    public CommandLineBuilder(boolean isScript) {
        this.lineSeparator = isScript ? SCRIPT_LINE_SEPARATOR : " ";
    }

    public static String escapeReferenceChar(String cmd) {
        if (cmd != null) {
            return cmd.replace(REFERENCE_VAR_CHAR, "\\$");
        }
        return null;
    }

    public static String makeEnvironmentVariableReference(EnvironmentVariable var) {
        return CommandLineBuilder.makeVariableReference(var.getName());
    }

    public static String makePathWithEnvironmentVariable(EnvironmentVariable var, String path, char fileSeparator) {
        String varRef = CommandLineBuilder.makeEnvironmentVariableReference(var);
        return FileUtils.joinPath((char)fileSeparator, (String[])new String[]{varRef, path});
    }

    public static String makeLinkDirName(Integer nodeId, String paramName) {
        return CommandLineBuilder.makeLinkName("dir", nodeId, paramName);
    }

    public static String makeFromPipeName(Integer nodeId, String paramName) {
        return CommandLineBuilder.makeLinkName("from", nodeId, paramName);
    }

    public static String makeToPipeName(Integer nodeId, String paramName) {
        return CommandLineBuilder.makeLinkName("to", nodeId, paramName);
    }

    private static String makeLinkName(String prefix, Integer nodeId, String paramName) {
        return String.valueOf(prefix) + "_" + nodeId + "_" + paramName;
    }

    public static String makeVariableReference(String var) {
        return REFERENCE_VAR_CHAR + var;
    }

    public CommandLineBuilder append(String string) {
        this.buffer.append(string);
        return this;
    }

    public CommandLineBuilder appendCommand(String command) {
        return this.append(String.valueOf(command) + COMMAND_SEPARATOR + this.lineSeparator);
    }

    public CommandLineBuilder appendComment(String comment) {
        return this.append(COMMENT + comment + this.lineSeparator);
    }

    public CommandLineBuilder appendCommentSeparator() {
        return this.appendComment("---------------------------------------------------");
    }

    public CommandLineBuilder appendEmptyLine() {
        return this.append(this.lineSeparator);
    }

    public CommandLineBuilder appendEnvironmentVariableDeclaration(EnvironmentVariable var, String varValue) {
        return this.appendEnvironmentVariableDeclaration(var.getName(), varValue);
    }

    public CommandLineBuilder appendEnvironmentVariableDeclaration(String varName, String varValue) {
        return this.appendCommand("export " + varName + "=" + varValue);
    }

    public CommandLineBuilder appendExitCodeCaptureCommand(String exitCodeFilePath, CommandLineContext context) {
        if (exitCodeFilePath != null) {
            char fileSeparator = context.getFileSeparator();
            String exitCodeVarName = "exit_code";
            String exitCodeVarValue = CommandLineBuilder.makeVariableReference(exitCodeVarName);
            String exitCodeLogFile = CommandLineBuilder.makePathWithEnvironmentVariable(EnvironmentVariable.PROJECT_DIR, exitCodeFilePath, fileSeparator);
            this.append(COMMAND_SEPARATOR).appendEmptyLine();
            this.appendCommand(String.valueOf(exitCodeVarName) + "=" + REFERENCE_VAR_CHAR + "?");
            this.append("echo " + exitCodeVarValue).redirectStdOutputToFile(exitCodeLogFile).append(COMMAND_SEPARATOR).appendEmptyLine();
            this.appendCommand("return " + exitCodeVarValue);
        }
        return this;
    }

    public CommandLineBuilder discardOutput() {
        return this.redirectStdOutputToFile("/dev/null");
    }

    public CommandLineBuilder discardStdErrAndStdOutput() {
        return this.discardOutput().redirectStdErrToStdOutput();
    }

    public CommandLineBuilder redirectStdErrAndStdOutputToFile(String standardOutputFile) {
        return this.redirectStdOutputToFile(standardOutputFile).redirectStdErrToStdOutput();
    }

    public CommandLineBuilder redirectStdErrToStdOutput() {
        return this.append(" 2>&1");
    }

    public CommandLineBuilder redirectStdOutputToFile(String standardOutputFile) {
        return this.append(" > " + standardOutputFile);
    }

    public String toString() {
        return this.buffer.toString();
    }

    public CommandLineBuilder appendScriptHeader(CommandLineContext context) {
        return this.append("#! ").append(SHELL).append(this.lineSeparator);
    }
}

