/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.flows.configurator;

import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.flows.configurator.Output;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.OutputFileParameter;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class Node
implements Serializable {
    private AlgorithmConfigurator configurator;
    private int id;
    private Map<String, Output> outputsByParameterName;

    public Node(int id, AlgorithmConfigurator configurator) {
        this.id = id;
        this.setConfigurator(configurator);
        this.createOutputs();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!this.getClass().equals(object.getClass())) {
            return false;
        }
        Node node = (Node)object;
        return this.getId() == node.getId();
    }

    public AlgorithmConfigurator getConfigurator() {
        return this.configurator;
    }

    public int getId() {
        return this.id;
    }

    public Output getOutput(String parameterName) {
        if (parameterName == null) {
            throw new IllegalArgumentException("O par\u00e2metro parameterName est\u00e1 nulo.");
        }
        return this.outputsByParameterName.get(parameterName);
    }

    public Collection<Output> getOutputs() {
        return Collections.unmodifiableCollection(this.outputsByParameterName.values());
    }

    public int hashCode() {
        return this.getId();
    }

    private void createOutputs() {
        this.outputsByParameterName = new HashMap<String, Output>();
        for (OutputFileParameter parameter : this.getConfigurator().getOutputFileParameters()) {
            if (parameter.getMode() == FileParameterMode.REGULAR_FILE) {
                this.outputsByParameterName.put(parameter.getName(), new Output(this.getId(), parameter.getName(), false));
                continue;
            }
            if (parameter.getMode() != FileParameterMode.DIRECTORY) continue;
            this.outputsByParameterName.put(parameter.getName(), new Output(this.getId(), parameter.getName(), true));
        }
    }

    private void setConfigurator(AlgorithmConfigurator configurator) {
        if (configurator == null) {
            throw new IllegalArgumentException("O par\u00e2metro configurator est\u00e1 nulo.");
        }
        this.configurator = configurator;
    }
}

