/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.exception.ParseException;
import csbase.logic.ClientSGAFile;
import csbase.logic.algorithms.CommandLineContext;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.validators.ClientSGAFileValidator;
import csbase.logic.algorithms.parameters.validators.SimpleParameterValidator;
import java.util.List;
import tecgraf.openbus.algorithmservice.v1_0.parameters.ClientSGAFileParameterHelper;

public class ClientSGAFileParameter
extends SimpleParameter<ClientSGAFile> {
    private boolean isMultipleSelection;
    private boolean showFiles;
    private boolean isInputMode;
    private List<String> types;

    public ClientSGAFileParameter(String name, String label, String description, ClientSGAFile defaultValue, boolean isOptional, boolean isVisible, String commandLinePattern) {
        super(name, label, description, defaultValue, isOptional, isVisible, commandLinePattern);
    }

    @Override
    public SimpleParameterValidator<ClientSGAFile> createParameterValidator() {
        return new ClientSGAFileValidator(this.isOptional());
    }

    @Override
    public Object getExpressionValue() {
        return null;
    }

    @Override
    public String getType() {
        return "CLIENT_SGA_FILE";
    }

    @Override
    public String getIDLType() {
        return ClientSGAFileParameterHelper.id();
    }

    @Override
    public void setValueAsText(String parameterValue) throws ParseException {
        if (parameterValue == null) {
            this.setValue(null);
            return;
        }
        int begin = 0;
        int end = parameterValue.indexOf(",");
        String sgaName = parameterValue.substring(0, end);
        begin = end + 1;
        end = parameterValue.indexOf(";", begin);
        String separator = parameterValue.substring(begin, end);
        String[] splited = parameterValue.substring(end + 1).split(";");
        ClientSGAFile file = null;
        int i = 0;
        while (i < splited.length) {
            String clientFileStr = splited[i];
            int count = 0;
            begin = 0;
            end = clientFileStr.indexOf(",");
            String[] values = new String[8];
            while (count < 7) {
                values[count] = clientFileStr.substring(begin, end);
                begin = end + 1;
                end = clientFileStr.indexOf(",", begin);
                ++count;
            }
            values[count] = clientFileStr.substring(begin);
            if (i == 0) {
                file = this.buildClientSGAFile(sgaName, separator, values);
            } else {
                ClientSGAFile brother = this.buildClientSGAFile(sgaName, separator, values);
                file.getBrothers().add(brother);
            }
            ++i;
        }
        this.setValue(file);
    }

    @Override
    protected String getCommandValue(CommandLineContext context) {
        StringBuilder paths = new StringBuilder();
        ClientSGAFile value = (ClientSGAFile)this.getValue();
        if (value == null) {
            return null;
        }
        paths.append(value.getStringPath());
        for (ClientSGAFile brother : value.getBrothers()) {
            paths.append(",");
            paths.append(brother.getStringPath());
        }
        return paths.toString();
    }

    public void setMultipleSelection(boolean isMultipleSelection) {
        this.isMultipleSelection = isMultipleSelection;
    }

    public boolean isMultipleSelection() {
        return this.isMultipleSelection;
    }

    public void setShowFiles(boolean showFiles) {
        this.showFiles = showFiles;
    }

    public boolean isShowFiles() {
        return this.showFiles;
    }

    public void setInputMode(boolean isInputMode) {
        this.isInputMode = isInputMode;
    }

    public boolean isInputMode() {
        return this.isInputMode;
    }

    public List<String> getTypes() {
        return this.types;
    }

    public void setTypes(List<String> types) {
        this.types = types;
    }

    private ClientSGAFile buildClientSGAFile(String sgaName, String separator, String[] values) {
        ClientSGAFile sgaFile = new ClientSGAFile(sgaName, values[6]);
        sgaFile.setSeparator(separator);
        sgaFile.setDir(Boolean.valueOf(values[0]));
        sgaFile.setSymbolicLink(Boolean.valueOf(values[1]));
        sgaFile.setCanRead(Boolean.valueOf(values[2]));
        sgaFile.setCanWrite(Boolean.valueOf(values[3]));
        sgaFile.setCanExecute(Boolean.valueOf(values[4]));
        sgaFile.setSize(Long.valueOf(values[5]));
        sgaFile.setLinkPath(values[7]);
        return sgaFile;
    }
}

