/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.exception.ParseException;
import csbase.exception.algorithms.ExpressionFunctionExecutionException;
import csbase.exception.algorithms.ExpressionFunctionNotFoundException;
import csbase.exception.algorithms.FormulaCreationException;
import csbase.exception.algorithms.FormulaEvaluationException;
import csbase.exception.algorithms.ParameterIsOffException;
import csbase.exception.algorithms.ParameterNotFoundException;
import csbase.exception.algorithms.ParameterValueNotExistsException;
import csbase.logic.algorithms.parameters.ExpressionFunctionExecutor;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.SimpleParameter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import tecgraf.javautils.jexpression.JExpression;
import tecgraf.javautils.jexpression.JExpressionHandler;
import tecgraf.javautils.jexpression.util.CalculatorHandler;

public final class Expression
implements Serializable {
    private SimpleAlgorithmConfigurator configurator;
    private boolean error;
    private String expressionText;
    private transient JExpression formula;
    private Set<SimpleParameter<?>> parameters = new HashSet();

    public Expression(String expressionText) throws FormulaCreationException, ParseException {
        this.setExpressionText(expressionText);
        this.createFormula();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public boolean evaluate(SimpleAlgorithmConfigurator algorithmConfigurator) throws FormulaEvaluationException {
        if (algorithmConfigurator == null) {
            throw new IllegalArgumentException("O par\u00e2metro configurator est\u00e1 nulo.");
        }
        this.error = false;
        this.configurator = algorithmConfigurator;
        try {
            Boolean result = (Boolean)this.formula.eval((JExpressionHandler)new ExpressionHandler(), Boolean.class);
            if (this.error) {
                return false;
            }
            boolean bl = result;
            return bl;
        }
        catch (ParameterIsOffException e) {
            return true;
        }
        catch (ParameterValueNotExistsException e) {
            return false;
        }
        catch (FormulaEvaluationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FormulaEvaluationException(e, "Ocorreu um erro ao avaliar a express\u00e3o {0}.\nDetalhes: {1}.", this, e.getLocalizedMessage());
        }
        finally {
            this.configurator = null;
        }
    }

    public SimpleAlgorithmConfigurator getConfigurator() {
        return this.configurator;
    }

    public Set<SimpleParameter<?>> getParameters() {
        return Collections.unmodifiableSet(this.parameters);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.expressionText;
    }

    private boolean addParameter(SimpleParameter<?> parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException("O par\u00e2metro parameter est\u00e1 nulo.");
        }
        return this.parameters.add(parameter);
    }

    private void createFormula() throws ParseException {
        try {
            this.formula = JExpression.compile((String)this.expressionText);
        }
        catch (Exception e) {
            throw new ParseException(e, "Ocorreu erro ao criar a f\u00f3rmula {0}.\nDetalhes: {1}.\n", this, e.getLocalizedMessage());
        }
    }

    private void readObject(ObjectInputStream inputStream) throws IOException, ClassNotFoundException {
        inputStream.defaultReadObject();
        try {
            this.createFormula();
        }
        catch (ParseException e) {
            IllegalStateException ise = new IllegalStateException();
            ise.initCause(e);
            throw ise;
        }
    }

    private void setExpressionText(String expressionText) {
        if (expressionText == null) {
            throw new IllegalArgumentException("O par\u00e2metro expressionText est\u00e1 nulo.\n");
        }
        this.expressionText = expressionText;
    }

    private class ExpressionHandler
    extends CalculatorHandler {
        private ExpressionHandler() {
        }

        public Object handleVar(String name) throws Exception {
            SimpleParameter<?> parameter = Expression.this.getConfigurator().getSimpleParameter(name);
            if (parameter == null) {
                throw new ParameterNotFoundException(name);
            }
            if (!parameter.isEnabled() || !parameter.isVisible()) {
                throw new ParameterIsOffException(parameter.getName());
            }
            Expression.this.addParameter(parameter);
            Object value = parameter.getExpressionValue();
            if (value == null) {
                throw new ParameterValueNotExistsException(name);
            }
            return value;
        }

        public Object handleFunctionCall(String name, List<Object> args) throws Exception {
            Object[] arguments = new Object[args.size()];
            int i = 0;
            while (i < args.size()) {
                Object argument = args.get(i);
                if (argument instanceof Boolean) {
                    arguments[i] = new Boolean((Boolean)argument);
                } else if (argument instanceof Double) {
                    arguments[i] = new Double((Double)argument);
                } else if (argument instanceof String) {
                    arguments[i] = argument.toString();
                } else {
                    throw new IllegalArgumentException("O par\u00e2metro arguments possui pelo menos um elemento que n\u00e3o \u00e9 do tipo suportado (booleano, string ou double).\n");
                }
                ++i;
            }
            try {
                return ExpressionFunctionExecutor.getInstance().execute(name, Expression.this.getConfigurator(), arguments);
            }
            catch (ExpressionFunctionExecutionException e) {
                throw new FormulaEvaluationException(e);
            }
            catch (ExpressionFunctionNotFoundException e) {
                throw new FormulaEvaluationException(e);
            }
        }
    }
}

