/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.exception.ParseException;
import csbase.logic.algorithms.CommandLineBuilder;
import csbase.logic.algorithms.CommandLineContext;
import csbase.logic.algorithms.EnvironmentVariable;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.URLProtocol;
import csbase.logic.algorithms.parameters.URLProtocolConverter;
import csbase.logic.algorithms.parameters.URLValue;
import csbase.logic.algorithms.parameters.validators.URLParameterValidator;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public abstract class URLParameter
extends SimpleParameter<URLValue> {
    private static final String PATH = ".path";
    private static final String TYPE = ".type";
    private static final String PROTOCOL = ".protocol";
    private static final String HOST = ".host";
    private String localization;
    private String fileType;
    private FileParameterMode mode;
    private boolean mustExist;
    private EnumSet<URLProtocol> allowedProtocols;

    public URLParameter(String name, String label, String description, URLValue defaultValue, boolean isOptional, boolean isVisible, String commandLinePattern, String localization, String fileType, FileParameterMode mode, boolean mustExist, EnumSet<URLProtocol> allowedProtocols) {
        super(name, label, description, defaultValue, isOptional, isVisible, commandLinePattern);
        if (mode == null) {
            throw new IllegalArgumentException("mode n\u00e3o pode ser nulo.");
        }
        this.localization = localization;
        this.fileType = fileType;
        this.mustExist = mustExist;
        this.allowedProtocols = allowedProtocols;
        this.mode = mode;
    }

    public String getLocalization() {
        return this.localization;
    }

    public String getFileType() {
        return this.fileType;
    }

    public FileParameterMode getMode() {
        return this.mode;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
        this.fireVisiblityWasChangedEvent();
    }

    public boolean mustExist() {
        return this.mustExist;
    }

    public EnumSet<URLProtocol> getAllowedProtocols() {
        return this.allowedProtocols;
    }

    public URLProtocol getDefaultProtocol() {
        if (this.allowedProtocols.size() == 0) {
            return URLValue.DEFAULT_PROTOCOL;
        }
        return (URLProtocol)((Object)this.allowedProtocols.iterator().next());
    }

    @Override
    public Object getExpressionValue() {
        return null;
    }

    public URLParameterValidator createParameterValidator() {
        return new URLParameterValidator(this.isOptional());
    }

    @Override
    public Map<String, Object> exportValue() {
        if (this.getValue() == null) {
            return new HashMap<String, Object>();
        }
        LinkedList exportableValues = new LinkedList();
        HashMap<String, String> exportableValue = new HashMap<String, String>();
        URLValue value = (URLValue)this.getValue();
        exportableValue.put(PATH, value.getPath());
        exportableValue.put(TYPE, value.getType());
        URLProtocol protocol = value.getProtocol();
        if (protocol != null) {
            exportableValue.put(PROTOCOL, protocol.getType());
        }
        exportableValue.put(HOST, value.getHost());
        exportableValues.add(Collections.unmodifiableMap(exportableValue));
        HashMap result = new HashMap();
        result.put(this.getName(), Collections.unmodifiableCollection(exportableValues));
        return Collections.unmodifiableMap(result);
    }

    @Override
    public void importValue(Map<String, Object> parameterValues) {
        Collection exportableValues = (Collection)parameterValues.get(this.getName());
        if (exportableValues == null || exportableValues.isEmpty()) {
            this.setValue(null);
            return;
        }
        Map exportableValue = (Map)exportableValues.iterator().next();
        String path = (String)exportableValue.get(PATH);
        String type = (String)exportableValue.get(TYPE);
        String protocolName = (String)exportableValue.get(PROTOCOL);
        String host = (String)exportableValue.get(HOST);
        if (protocolName != null) {
            try {
                URLProtocol protocol = new URLProtocolConverter().valueOf(protocolName);
                this.setValue(new URLValue(path, type, protocol, host));
                return;
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Protocolo " + protocolName + " inv\u00e1lido");
            }
        }
        this.setValue(new URLValue(path, type));
    }

    @Override
    public String getCommandValue(CommandLineContext context) {
        URLValue file = (URLValue)this.getValue();
        if (file == null) {
            return null;
        }
        String path = file.getPath();
        URLProtocol protocol = file.getProtocol();
        if (!path.startsWith("$")) {
            char fileSeparator = context.getFileSeparator();
            path = file.getPath(fileSeparator);
            switch (protocol) {
                case PROJECT: {
                    String filePath = file.getPath(fileSeparator);
                    if (filePath.startsWith("/")) {
                        filePath = filePath.substring(1);
                    }
                    path = CommandLineBuilder.makePathWithEnvironmentVariable(EnvironmentVariable.PROJECT_DIR, filePath, fileSeparator);
                    break;
                }
                default: {
                    String commandValue = protocol.getCommandValue();
                    if (commandValue == null) break;
                    path = String.valueOf(commandValue) + path;
                }
            }
        }
        String f = "%s %s=%s";
        return String.format(f, path, this.getLocalization(), protocol.getType());
    }

    @Override
    public String getValueAsText() {
        URLValue file = (URLValue)this.getValue();
        return URLValue.getStringValue(file);
    }

    @Override
    public void setValueAsText(String parameterValue) {
        URLValue value = URLValue.getURLFromString(this.mode, parameterValue);
        this.setValue(value);
    }
}

