/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters.validators;

import csbase.exception.ServiceFailureException;
import csbase.logic.ClientProjectFile;
import csbase.logic.algorithms.FileParameterValue;
import csbase.logic.algorithms.parameters.FileParameter;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileParameterPipeAcceptance;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.validators.SimpleParameterValidator;
import csbase.logic.algorithms.validation.LocalizedMessage;
import csbase.logic.algorithms.validation.Validation;
import csbase.logic.algorithms.validation.ValidationContext;
import csbase.logic.algorithms.validation.ValidationError;
import csbase.logic.algorithms.validation.ValidationMode;
import csbase.logic.algorithms.validation.ValidationSuccess;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.ProjectServiceInterface;
import java.rmi.RemoteException;
import java.util.Arrays;
import tecgraf.javautils.core.io.FileUtils;

public class FileParameterValidator
extends SimpleParameterValidator<FileParameterValue> {
    public FileParameterValidator(boolean optional) {
        super(optional);
    }

    @Override
    public final Validation validateValue(SimpleParameter<?> parameter, FileParameterValue value, ValidationContext context) throws RemoteException {
        if (!parameter.isVisible()) {
            return new ValidationSuccess();
        }
        if (!parameter.isEnabled()) {
            return new ValidationSuccess();
        }
        FileParameter fileParameter = (FileParameter)parameter;
        if (fileParameter.hasLink()) {
            return new ValidationSuccess();
        }
        if (fileParameter.usesPipe() == FileParameterPipeAcceptance.ALWAYS && context.getMode() == ValidationMode.FULL) {
            LocalizedMessage message = new LocalizedMessage(FileParameterValidator.class, "must_use_pipe", new Object[]{parameter.getLabel()});
            return new ValidationError(message);
        }
        Validation result = super.validateValue(parameter, value, context);
        if (!result.isWellSucceded()) {
            return result;
        }
        if (value != null) {
            return this.validateFile(value, fileParameter.getMode(), context.getProjectId(), fileParameter.mustExist());
        }
        return new ValidationSuccess();
    }

    public Validation validateFile(FileParameterValue file, FileParameterMode mode, Object projectId, boolean mustExist) throws RemoteException {
        if (projectId == null) {
            LocalizedMessage message = new LocalizedMessage(FileParameterValidator.class, "no_project", new Object[]{file.getPath()});
            return new ValidationError(message);
        }
        String[] path = file.getPathAsArray();
        Validation fileNameResult = FileParameterValidator.validateFileName(path);
        if (!fileNameResult.isWellSucceded()) {
            return fileNameResult;
        }
        ClientProjectFile projectFile = this.getFile(path, projectId);
        if (projectFile != null) {
            return this.validateFileMode(mode, projectFile);
        }
        if (mustExist) {
            LocalizedMessage message = new LocalizedMessage(FileParameterValidator.class, "file_not_found", new Object[]{file.getPath()});
            return new ValidationError(message);
        }
        return this.validateParent(file, projectId);
    }

    public static Validation validateFileName(String[] path) {
        String[] stringArray = path;
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            String component = stringArray[n2];
            String fixedFileName = FileUtils.fixFileName((String)component);
            if (!fixedFileName.equals(component)) {
                LocalizedMessage message = new LocalizedMessage(FileParameterValidator.class, "invalid_file_name", new Object[]{component});
                return new ValidationError(message);
            }
            ++n2;
        }
        return new ValidationSuccess();
    }

    private Validation validateFileMode(FileParameterMode mode, ClientProjectFile projectFile) {
        if (mode == FileParameterMode.DIRECTORY && !projectFile.isDirectory()) {
            LocalizedMessage message = new LocalizedMessage(FileParameterValidator.class, "not_directory", new Object[]{projectFile.getStringPath()});
            return new ValidationError(message);
        }
        if (mode == FileParameterMode.REGULAR_FILE && projectFile.isDirectory()) {
            LocalizedMessage message = new LocalizedMessage(FileParameterValidator.class, "not_file", new Object[]{projectFile.getStringPath()});
            return new ValidationError(message);
        }
        return new ValidationSuccess();
    }

    private Validation validateParent(FileParameterValue file, Object projectId) throws RemoteException {
        String[] parentPath = file.getPathAsArray();
        while (parentPath.length > 1) {
            String parentName = (parentPath = Arrays.copyOf(parentPath, parentPath.length - 1))[parentPath.length - 1];
            if (parentName.equals(".")) continue;
            ClientProjectFile parentProjectFile = this.getFile(parentPath, projectId);
            if (parentProjectFile == null) {
                LocalizedMessage message = new LocalizedMessage(FileParameterValidator.class, "file_not_found", new Object[]{FileUtils.joinPath((String[])parentPath)});
                return new ValidationError(message);
            }
            if (!parentProjectFile.isDirectory()) {
                LocalizedMessage message = new LocalizedMessage(FileParameterValidator.class, "not_directory", new Object[]{parentProjectFile.getStringPath()});
                return new ValidationError(message);
            }
            return new ValidationSuccess();
        }
        return new ValidationSuccess();
    }

    private ClientProjectFile getFile(String[] path, Object projectId) throws RemoteException {
        try {
            ProjectServiceInterface projectService = ClientRemoteLocator.projectService;
            if (projectService.existsFile(projectId, path)) {
                return projectService.getChild(projectId, path);
            }
            return null;
        }
        catch (ServiceFailureException e) {
            return null;
        }
    }
}

