/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.EnumerationItem;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parsers.SimpleParameterParser;
import csbase.logic.algorithms.parsers.XmlParser;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractEnumerationParameterParser<T extends SimpleParameter<?>>
extends SimpleParameterParser<T> {
    static final String ENUMERATION_ELEMENT_MUST_SORT_ATTRIBUTE = "ordenar";
    static final boolean ENUMERATION_ELEMENT_MUST_SORT_DEFAULT_VALUE = true;
    static final String ENUMERATION_ITEM_ELEMENT = "item_de_enumeracao";
    static final String ENUMERATION_ITEM_DESCRIPTION_ATTRIBUTE = "dica";
    static final String ENUMERATION_ITEM_ID_ATTRIBUTE = "id";
    static final String ENUMERATION_ITEM_LABEL_ATTRIBUTE = "rotulo";
    static final String ENUMERATION_ITEM_VALUE_ATTRIBUTE = "valor";

    @Override
    public T createSimpleParameter(XmlParser parser, String name, String label, String description, boolean isOptional, boolean isVisible, String commandLinePattern, ParameterGroup group) throws ParseException {
        boolean mustSort = parser.extractAttributeValueAsBoolean(ENUMERATION_ELEMENT_MUST_SORT_ATTRIBUTE, true);
        List<EnumerationItem> items = this.loadEnumerationItems(parser, name);
        String defaultItemId = parser.extractAttributeValue("padrao", null);
        return this.createEnumerationParameter(parser, name, label, description, isOptional, isVisible, commandLinePattern, mustSort, items, defaultItemId);
    }

    protected abstract T createEnumerationParameter(XmlParser var1, String var2, String var3, String var4, boolean var5, boolean var6, String var7, boolean var8, List<EnumerationItem> var9, String var10) throws ParseException;

    protected List<EnumerationItem> loadEnumerationItems(XmlParser parser, String parameterName) throws ParseException {
        LinkedList<EnumerationItem> items = new LinkedList<EnumerationItem>();
        if (parser.goToFirstChild(ENUMERATION_ITEM_ELEMENT)) {
            do {
                EnumerationItem enumerationItem;
                if (items.contains(enumerationItem = this.loadEnumerationItem(parser))) {
                    throw new ParseException("O item {0} est\u00e1 duplicado na enumera\u00e7\u00e3o {1}.", enumerationItem.getId(), parameterName);
                }
                for (EnumerationItem item : items) {
                    if (!enumerationItem.getLabel().equals(item.getLabel())) continue;
                    throw new ParseException("O item {0} est\u00e1 duplicado na enumera\u00e7\u00e3o {1}.", enumerationItem.getLabel(), parameterName);
                }
                items.add(enumerationItem);
            } while (parser.goToNextSibling(ENUMERATION_ITEM_ELEMENT));
            parser.goToParent();
        }
        return items;
    }

    protected EnumerationItem loadEnumerationItem(XmlParser parser) throws ParseException {
        String id = parser.extractAttributeValue(ENUMERATION_ITEM_ID_ATTRIBUTE);
        String label = parser.extractAttributeValue(ENUMERATION_ITEM_LABEL_ATTRIBUTE);
        String value = parser.extractAttributeValue(ENUMERATION_ITEM_VALUE_ATTRIBUTE);
        String description = parser.extractAttributeValue(ENUMERATION_ITEM_DESCRIPTION_ATTRIBUTE, null);
        parser.checkAttributes();
        parser.checkChildElements();
        EnumerationItem enumerationItem = new EnumerationItem(id, label, value, description);
        return enumerationItem;
    }

    protected EnumerationItem getEnumerationItem(String enumerationName, List<EnumerationItem> items, String itemId) throws ParseException {
        for (EnumerationItem item : items) {
            if (!item.getId().equals(itemId)) continue;
            return item;
        }
        throw new ParseException("Erro ao tentar criar a enumera\u00e7\u00e3o {0}: O item padr\u00e3o {1} n\u00e3o est\u00e1 definido.", enumerationName, itemId);
    }
}

