/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers;

import csbase.exception.OperationFailureException;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.Category;
import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class CategoryParser {
    private static final String ALGORITHM_ELEMENT_ID_ATTRIBUTE_NAME = "id";
    private static final String ALGORITHM_ELEMENT_NAME = "algorithm";
    private static final String CATEGORY_ELEMENT_ID_ATTRIBUTE_NAME = "id";
    private static final String CATEGORY_ELEMENT_NAME = "category";
    private static final String CATEGORY_ELEMENT_NAME_ATTRIBUTE_NAME = "name";
    private DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

    protected CategoryParser() {
        this.factory.setCoalescing(true);
        this.factory.setIgnoringComments(true);
        this.factory.setIgnoringElementContentWhitespace(true);
        this.factory.setExpandEntityReferences(false);
    }

    public final Set<Category> read(Reader reader) throws OperationFailureException {
        if (reader == null) {
            throw new IllegalArgumentException("O par\u00e2metro reader est\u00e1 nulo.");
        }
        try {
            DocumentBuilder builder = this.factory.newDocumentBuilder();
            Document document = builder.parse(new InputSource(reader));
            return this.readCategories(document.getDocumentElement());
        }
        catch (ParserConfigurationException e) {
            throw new OperationFailureException("Erro nas configura\u00e7\u00f5es do parser.", e);
        }
        catch (SAXException e) {
            Exception ex = e.getException();
            if (ex == null) {
                ex = e;
            }
            throw new OperationFailureException("Erro de sintaxe no XML.", ex);
        }
        catch (IOException e) {
            throw new OperationFailureException("Erro de IO.", e);
        }
    }

    protected abstract AlgorithmInfo getAlgorithmById(String var1) throws OperationFailureException;

    private String getAttributeValue(Element element, String attributeName) throws OperationFailureException {
        Attr attribute = element.getAttributeNode(attributeName);
        if (attribute == null) {
            throw new OperationFailureException("O atributo {1} do elemento {0} n\u00e3o foi encontrado.\n", element.getNodeName(), attributeName);
        }
        return attribute.getNodeValue();
    }

    private List<Element> getChildElements(Element element, String elementName) {
        LinkedList<Element> elements = new LinkedList<Element>();
        NodeList children = element.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Element childElement;
            Node childNode = children.item(i);
            if (childNode.getNodeType() == 1 && (childElement = (Element)childNode).getNodeName().equals(elementName)) {
                elements.add(childElement);
            }
            ++i;
        }
        return elements;
    }

    private Set<Category> readCategories(Element element) throws OperationFailureException {
        HashSet<Category> categories = new HashSet<Category>();
        List<Element> elements = this.getChildElements(element, CATEGORY_ELEMENT_NAME);
        for (Element childElement : elements) {
            Category category = this.readCategory(childElement);
            categories.add(category);
        }
        return categories;
    }

    private Category readCategory(Element element) throws OperationFailureException {
        String name = this.getAttributeValue(element, "id");
        String id = this.getAttributeValue(element, CATEGORY_ELEMENT_NAME_ATTRIBUTE_NAME);
        Category newCategory = new Category(null, name, id);
        Set<Category> categories = this.readCategories(element);
        for (Category childCategory : categories) {
            newCategory.addCategory(childCategory);
        }
        List<Element> elements = this.getChildElements(element, ALGORITHM_ELEMENT_NAME);
        for (Element algorithmElement : elements) {
            String algorithmId = this.getAttributeValue(algorithmElement, "id");
            AlgorithmInfo algorithm = this.getAlgorithmById(algorithmId);
            if (algorithm == null) continue;
            newCategory.addAlgorithm(algorithm);
        }
        return newCategory;
    }
}

