/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.BooleanParameter;
import csbase.logic.algorithms.parameters.DoubleListParameter;
import csbase.logic.algorithms.parameters.DoubleParameter;
import csbase.logic.algorithms.parameters.EnumerationItem;
import csbase.logic.algorithms.parameters.EnumerationParameter;
import csbase.logic.algorithms.parameters.FileParameter;
import csbase.logic.algorithms.parameters.IntegerListParameter;
import csbase.logic.algorithms.parameters.IntegerParameter;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.TextParameter;
import csbase.logic.algorithms.parameters.conditions.Condition;
import csbase.logic.algorithms.parameters.triggers.AllowEditParameterTrigger;
import csbase.logic.algorithms.parameters.triggers.ChangeDefaultValueTrigger;
import csbase.logic.algorithms.parameters.triggers.ChangeFileTypeTrigger;
import csbase.logic.algorithms.parameters.triggers.ChangeLabelTrigger;
import csbase.logic.algorithms.parameters.triggers.ChangeMaximumForDoublesTrigger;
import csbase.logic.algorithms.parameters.triggers.ChangeMaximumForIntegersTrigger;
import csbase.logic.algorithms.parameters.triggers.ChangeMinimumForDoublesTrigger;
import csbase.logic.algorithms.parameters.triggers.ChangeMinimumForIntegersTrigger;
import csbase.logic.algorithms.parameters.triggers.DisableParameterTrigger;
import csbase.logic.algorithms.parameters.triggers.EnableParameterTrigger;
import csbase.logic.algorithms.parameters.triggers.HideGroupTrigger;
import csbase.logic.algorithms.parameters.triggers.HideParameterTrigger;
import csbase.logic.algorithms.parameters.triggers.ProhibitEditParameterTrigger;
import csbase.logic.algorithms.parameters.triggers.SetVisibleEnumerationItemTrigger;
import csbase.logic.algorithms.parameters.triggers.ShowGroupTrigger;
import csbase.logic.algorithms.parameters.triggers.ShowParameterTrigger;
import csbase.logic.algorithms.parameters.triggers.Trigger;
import csbase.logic.algorithms.parsers.ConditionParser;
import csbase.logic.algorithms.parsers.XmlParser;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class TriggerParser {
    private static final String ALLOW_EDIT_TRIGGER_ELEMENT = "permitir_edicao";
    private static final String CHANGE_DEFAULT_VALUE_TRIGGER_ELEMENT = "trocar_valor_padrao";
    private static final String CHANGE_DEFAULT_VALUE_TRIGGER_ELEMENT_NEW_DEFAULT_VALUE_ATTRIBUTE = "novo_valor_padrao";
    private static final String CHANGE_FILE_TYPE_TRIGGER_ELEMENT = "trocar_tipo_de_arquivo";
    private static final String CHANGE_FILE_TYPE_TRIGGER_ELEMENT_NEW_FILE_TYPE_ATTRIBUTE = "novo_tipo";
    private static final String CHANGE_LABEL_TRIGGER_ELEMENT = "trocar_rotulo";
    private static final String CHANGE_LABEL_TRIGGER_ELEMENT_NEW_LABEL_ATTRIBUTE = "novo_rotulo";
    private static final String CHANGE_MAXIMUM_TRIGGER_ELEMENT = "trocar_maximo";
    private static final String CHANGE_MAXIMUM_TRIGGER_ELEMENT_INCLUDE_NEW_MAXIMUM_ATTRIBUTE = "incluir_novo_maximo";
    private static final boolean CHANGE_MAXIMUM_TRIGGER_ELEMENT_INCLUDE_NEW_MAXIMUM_DEFAULT_VALUE = true;
    private static final String CHANGE_MAXIMUM_TRIGGER_ELEMENT_NEW_MAXIMUM_ATTRIBUTE = "novo_maximo";
    private static final String CHANGE_MINIMUM_TRIGGER_ELEMENT = "trocar_minimo";
    private static final String CHANGE_MINIMUM_TRIGGER_ELEMENT_INCLUDE_NEW_MINIMUM_ATTRIBUTE = "incluir_novo_minimo";
    private static final boolean CHANGE_MINIMUM_TRIGGER_ELEMENT_INCLUDE_NEW_MINIMUM_DEFAULT_VALUE = true;
    private static final String CHANGE_MINIMUM_TRIGGER_ELEMENT_NEW_MINIMUM_ATTRIBUTE = "novo_minimo";
    private static final String DISABLE_PARAMETER_TRIGGER_ELEMENT = "desabilitar";
    private static final String ENABLE_PARAMETER_TRIGGER_ELEMENT = "habilitar";
    private static final String HIDE_ENUMERATION_ITEM_TRIGGER_ELEMENT = "ocultar_item";
    private static final String HIDE_PARAMETER_TRIGGER_ELEMENT = "ocultar";
    private static final String HIDE_GROUP_TRIGGER_ELEMENT = "ocultar_grupo";
    private static final String PROHIBIT_EDIT_PARAMETER_TRIGGER_ELEMENT = "proibir_edicao";
    private static final String SET_VISIBLE_ENUMERATION_ITEM_TRIGGER_ELEMENT_ITEM_ATTRIBUTE = "item";
    private static final String SHOW_ENUMERATION_ITEM_TRIGGER_ELEMENT = "exibir_item";
    private static final String SHOW_PARAMETER_TRIGGER_ELEMENT = "exibir";
    private static final String SHOW_GROUP_TRIGGER_ELEMENT = "exibir_grupo";
    private static final String TRIGGER_ELEMENT_PARAMETER_ATTRIBUTE = "parametro";
    private static final String TRIGGER_PARAMETER_ELEMENT = "parametro";
    private static final String TRIGGER_ELEMENT_GROUP_ATTRIBUTE = "grupo";
    private static final String TRIGGER_GROUP_ELEMENT = "grupo";
    private static final String TRIGGER_GROUP_ELEMENT_ID_ATTRIBUTE = "id";
    private static final String TRIGGER_PARAMETER_ELEMENT_NAME_ATTRIBUTE = "nome";

    public void loadTriggers(XmlParser parser, SimpleAlgorithmConfigurator configurator) throws ParseException {
        if (parser.goToFirstChild()) {
            do {
                Trigger trigger = null;
                List<Trigger> triggers = null;
                String elementName = parser.getElementName();
                if (elementName.equals(ALLOW_EDIT_TRIGGER_ELEMENT)) {
                    trigger = this.loadAllowEditTrigger(parser, configurator);
                } else if (elementName.equals(CHANGE_DEFAULT_VALUE_TRIGGER_ELEMENT)) {
                    trigger = this.loadChangeDefaultValueTrigger(parser, configurator);
                } else if (elementName.equals(CHANGE_FILE_TYPE_TRIGGER_ELEMENT)) {
                    trigger = this.loadChangeFileTypeTrigger(parser, configurator);
                } else if (elementName.equals(CHANGE_LABEL_TRIGGER_ELEMENT)) {
                    trigger = this.loadChangeLabelTrigger(parser, configurator);
                } else if (elementName.equals(CHANGE_MAXIMUM_TRIGGER_ELEMENT)) {
                    trigger = this.loadChangeMaximumTrigger(parser, configurator);
                } else if (elementName.equals(CHANGE_MINIMUM_TRIGGER_ELEMENT)) {
                    trigger = this.loadChangeMinimumTrigger(parser, configurator);
                } else if (elementName.equals(DISABLE_PARAMETER_TRIGGER_ELEMENT)) {
                    triggers = this.loadDisableParameterTriggers(parser, configurator);
                } else if (elementName.equals(ENABLE_PARAMETER_TRIGGER_ELEMENT)) {
                    triggers = this.loadEnableParameterTrigger(parser, configurator);
                } else if (elementName.equals(HIDE_ENUMERATION_ITEM_TRIGGER_ELEMENT)) {
                    trigger = this.loadSetVisibleEnumerationItemTrigger(parser, configurator, false);
                } else if (elementName.equals(HIDE_PARAMETER_TRIGGER_ELEMENT)) {
                    triggers = this.loadHideParameterTriggers(parser, configurator);
                } else if (elementName.equals(HIDE_GROUP_TRIGGER_ELEMENT)) {
                    triggers = this.loadHideGroupTriggers(parser, configurator);
                } else if (elementName.equals(PROHIBIT_EDIT_PARAMETER_TRIGGER_ELEMENT)) {
                    trigger = this.loadProhibitEditTrigger(parser, configurator);
                } else if (elementName.equals(SHOW_ENUMERATION_ITEM_TRIGGER_ELEMENT)) {
                    trigger = this.loadSetVisibleEnumerationItemTrigger(parser, configurator, true);
                } else if (elementName.equals(SHOW_PARAMETER_TRIGGER_ELEMENT)) {
                    triggers = this.loadShowParameterTriggers(parser, configurator);
                } else if (elementName.equals(SHOW_GROUP_TRIGGER_ELEMENT)) {
                    triggers = this.loadShowGroupTriggers(parser, configurator);
                }
                if (triggers != null) {
                    for (Trigger trigger2 : triggers) {
                        if (configurator.addTrigger(trigger2)) continue;
                        throw new ParseException("Foi encontrado um gatilho repetido no algoritmo {0}.\nGatilho repetido: {1}.\n", configurator, trigger2);
                    }
                }
                if (trigger == null || configurator.addTrigger(trigger)) continue;
                throw new ParseException("Foi encontrado um gatilho repetido no algoritmo {0}.\nGatilho repetido: {1}.\n", configurator, trigger);
            } while (parser.goToNextSibling());
            parser.goToParent();
        }
    }

    private ProhibitEditParameterTrigger loadProhibitEditTrigger(XmlParser parser, SimpleAlgorithmConfigurator configurator) throws ParseException {
        String parameterName = parser.extractAttributeValue("parametro");
        parser.checkAttributes();
        SimpleParameter<?> parameter = configurator.getSimpleParameter(parameterName);
        if (parameter == null) {
            throw new ParseException("O par\u00e2metro {0} que est\u00e1 referenciado no elemento {1} atributo {2} n\u00e3o est\u00e1 definido.", parameterName, ENABLE_PARAMETER_TRIGGER_ELEMENT, "parametro");
        }
        if (!(parameter instanceof TextParameter)) {
            throw new ParseException("O par\u00e2metro {0} que est\u00e1 referenciado no elemento {1} atributo {2} n\u00e3o \u00e9 do tipo texto.", parameterName, ENABLE_PARAMETER_TRIGGER_ELEMENT, "parametro");
        }
        TextParameter textParameter = (TextParameter)parameter;
        Condition condition = this.loadTriggerCondition(parser, configurator);
        return new ProhibitEditParameterTrigger(textParameter, condition);
    }

    private SetVisibleEnumerationItemTrigger loadSetVisibleEnumerationItemTrigger(XmlParser parser, SimpleAlgorithmConfigurator configurator, boolean isVisible) throws ParseException {
        String parameterName = parser.extractAttributeValue("parametro");
        SimpleParameter<?> parameter = configurator.getSimpleParameter(parameterName);
        if (parameter == null) {
            throw new ParseException("O par\u00e2metro {0} que est\u00e1 referenciado no elemento {1} atributo {2} n\u00e3o est\u00e1 definido.", parameterName, HIDE_ENUMERATION_ITEM_TRIGGER_ELEMENT, "parametro");
        }
        if (!(parameter instanceof EnumerationParameter)) {
            throw new ParseException("O par\u00e2metro {0} n\u00e3o \u00e9 uma enumera\u00e7\u00e3o com sele\u00e7\u00e3o simples.", parameterName, "item_de_enumeracao");
        }
        EnumerationParameter enumerationParameter = (EnumerationParameter)parameter;
        String itemId = parser.extractAttributeValue(SET_VISIBLE_ENUMERATION_ITEM_TRIGGER_ELEMENT_ITEM_ATTRIBUTE);
        EnumerationItem item = enumerationParameter.getItem(itemId);
        if (item == null) {
            throw new ParseException("N\u00e3o existe um item chamado {1} na enumera\u00e7\u00e3o {0}.", parameter, itemId);
        }
        parser.checkAttributes();
        Condition condition = this.loadTriggerCondition(parser, configurator);
        return new SetVisibleEnumerationItemTrigger(enumerationParameter, condition, itemId, isVisible);
    }

    private List<ShowParameterTrigger> loadShowParameterTriggers(XmlParser parser, SimpleAlgorithmConfigurator configurator) throws ParseException {
        Condition condition = this.loadTriggerCondition(parser, configurator);
        Set<SimpleParameter<?>> parameters = this.loadTriggerParameters(parser, configurator);
        parser.checkAttributes();
        LinkedList<ShowParameterTrigger> triggers = new LinkedList<ShowParameterTrigger>();
        for (SimpleParameter<?> parameter : parameters) {
            triggers.add(new ShowParameterTrigger(parameter, condition));
        }
        return Collections.unmodifiableList(triggers);
    }

    private List<ShowGroupTrigger> loadShowGroupTriggers(XmlParser parser, SimpleAlgorithmConfigurator configurator) throws ParseException {
        Condition condition = this.loadTriggerCondition(parser, configurator);
        Set<ParameterGroup> groups = this.loadTriggerGroups(parser, configurator);
        parser.checkAttributes();
        LinkedList<ShowGroupTrigger> triggers = new LinkedList<ShowGroupTrigger>();
        for (ParameterGroup group : groups) {
            triggers.add(new ShowGroupTrigger(group, condition));
        }
        return Collections.unmodifiableList(triggers);
    }

    private Condition loadTriggerCondition(XmlParser parser, SimpleAlgorithmConfigurator configurator) throws ParseException {
        Condition condition = null;
        if (parser.goToFirstChild("condicao") || parser.goToFirstChild("ou") || parser.goToFirstChild("e") || parser.goToFirstChild("nao")) {
            ConditionParser conditionParser = new ConditionParser();
            condition = conditionParser.loadCondition(parser, configurator);
            parser.goToParent();
            return condition;
        }
        throw new ParseException("A condi\u00e7\u00e3o de uma restri\u00e7\u00e3o n\u00e3o est\u00e1 definida.");
    }

    private Set<SimpleParameter<?>> loadTriggerParameters(XmlParser parser, SimpleAlgorithmConfigurator configurator) throws ParseException {
        SimpleParameter<?> parameter;
        String elementName = parser.getElementName();
        HashSet parameters = new HashSet();
        String parameterName = parser.extractAttributeValue("parametro", null);
        if (parameterName != null) {
            parameter = configurator.getSimpleParameter(parameterName);
            if (parameter == null) {
                throw new ParseException("O par\u00e2metro {0} que est\u00e1 referenciado no elemento {1} atributo {2} n\u00e3o est\u00e1 definido.", parameterName, elementName, "parametro");
            }
            parameters.add(parameter);
        }
        if (parser.goToFirstChild("parametro")) {
            do {
                if ((parameter = configurator.getSimpleParameter(parameterName = parser.getAttributeValue(TRIGGER_PARAMETER_ELEMENT_NAME_ATTRIBUTE))) == null) {
                    throw new ParseException("O par\u00e2metro {0} que est\u00e1 referenciado no elemento {1} atributo {2} n\u00e3o est\u00e1 definido.", parameterName, "parametro", TRIGGER_PARAMETER_ELEMENT_NAME_ATTRIBUTE);
                }
                parameters.add(parameter);
            } while (parser.goToNextSibling("parametro"));
            parser.goToParent();
        }
        if (parameters.isEmpty()) {
            throw new ParseException(String.format("Os par\u00e2metros associados ao gatilho representado pelo elemento %s n\u00e3o foram informados.", elementName));
        }
        return parameters;
    }

    private Set<ParameterGroup> loadTriggerGroups(XmlParser parser, SimpleAlgorithmConfigurator configurator) throws ParseException {
        ParameterGroup triggerGroup;
        String elementName = parser.getElementName();
        HashSet<ParameterGroup> parameters = new HashSet<ParameterGroup>();
        String groupName = parser.extractAttributeValue("grupo", null);
        if (groupName != null) {
            triggerGroup = this.findGroupByName(configurator.getGroups(), groupName);
            if (triggerGroup == null) {
                throw new ParseException("O grupo {0} que est\u00e1 referenciado no elemento {1} atributo {2} n\u00e3o est\u00e1 definido.", groupName, elementName, "grupo");
            }
            parameters.add(triggerGroup);
        }
        if (parser.goToFirstChild("grupo")) {
            do {
                groupName = parser.getAttributeValue(TRIGGER_GROUP_ELEMENT_ID_ATTRIBUTE);
                triggerGroup = this.findGroupByName(configurator.getGroups(), groupName);
                if (triggerGroup == null) {
                    throw new ParseException("O grupo {0} que est\u00e1 referenciado no elemento {1} atributo {2} n\u00e3o est\u00e1 definido.", groupName, "grupo", TRIGGER_GROUP_ELEMENT_ID_ATTRIBUTE);
                }
                parameters.add(triggerGroup);
            } while (parser.goToNextSibling("grupo"));
            parser.goToParent();
        }
        if (parameters.isEmpty()) {
            throw new ParseException(String.format("Os grupos associados ao gatilho representado pelo elemento %s n\u00e3o foram informados.", elementName));
        }
        return parameters;
    }

    private ParameterGroup findGroupByName(Collection<ParameterGroup> groups, String groupName) throws ParseException {
        ParameterGroup groupFound = null;
        for (ParameterGroup group : groups) {
            ParameterGroup childGroup;
            if (group.getName().equals(groupName)) {
                if (groupFound == null) {
                    groupFound = group;
                } else {
                    throw new ParseException("Foi encontrado mais de um grupo com o identificador \"{0}\".", groupName);
                }
            }
            if ((childGroup = this.findGroupByName(group.getGroups(), groupName)) == null) continue;
            if (groupFound == null) {
                groupFound = childGroup;
                continue;
            }
            throw new ParseException("Foi encontrado mais de um grupo com o identificador \"{0}\".", groupName);
        }
        return groupFound;
    }

    private Trigger<?> loadAllowEditTrigger(XmlParser parser, SimpleAlgorithmConfigurator configurator) throws ParseException {
        String parameterName = parser.extractAttributeValue("parametro");
        parser.checkAttributes();
        SimpleParameter<?> parameter = configurator.getSimpleParameter(parameterName);
        if (parameter == null) {
            throw new ParseException("O par\u00e2metro {0} que est\u00e1 referenciado no elemento {1} atributo {2} n\u00e3o est\u00e1 definido.", parameterName, ENABLE_PARAMETER_TRIGGER_ELEMENT, "parametro");
        }
        if (!(parameter instanceof TextParameter)) {
            throw new ParseException("O par\u00e2metro {0} que est\u00e1 referenciado no elemento {1} atributo {2} n\u00e3o \u00e9 do tipo texto.", parameterName, ENABLE_PARAMETER_TRIGGER_ELEMENT, "parametro");
        }
        TextParameter textParameter = (TextParameter)parameter;
        Condition condition = this.loadTriggerCondition(parser, configurator);
        return new AllowEditParameterTrigger(textParameter, condition);
    }

    private ChangeDefaultValueTrigger<?> loadChangeDefaultValueTrigger(XmlParser parser, SimpleAlgorithmConfigurator configurator) throws ParseException {
        String parameterName = parser.extractAttributeValue("parametro");
        SimpleParameter<?> parameter = configurator.getSimpleParameter(parameterName);
        if (parameter == null) {
            throw new ParseException("O par\u00e2metro {0} que est\u00e1 referenciado no elemento {1} atributo {2} n\u00e3o est\u00e1 definido.", parameterName, CHANGE_MAXIMUM_TRIGGER_ELEMENT, "parametro");
        }
        Condition condition = this.loadTriggerCondition(parser, configurator);
        if (parameter instanceof TextParameter) {
            TextParameter textParam = (TextParameter)parameter;
            String defaultValue = parser.extractAttributeValue(CHANGE_DEFAULT_VALUE_TRIGGER_ELEMENT_NEW_DEFAULT_VALUE_ATTRIBUTE, null);
            parser.checkAttributes();
            return this.createChangeDefaultValueTrigger(textParam, condition, defaultValue);
        }
        if (parameter instanceof IntegerParameter) {
            IntegerParameter intParam = (IntegerParameter)parameter;
            Integer defaultValue = parser.extractAttributeValueAsInteger(CHANGE_DEFAULT_VALUE_TRIGGER_ELEMENT_NEW_DEFAULT_VALUE_ATTRIBUTE, null);
            parser.checkAttributes();
            return this.createChangeDefaultValueTrigger(intParam, condition, defaultValue);
        }
        if (parameter instanceof DoubleParameter) {
            DoubleParameter doubleParam = (DoubleParameter)parameter;
            Double defaultValue = parser.extractAttributeValueAsDouble(CHANGE_DEFAULT_VALUE_TRIGGER_ELEMENT_NEW_DEFAULT_VALUE_ATTRIBUTE, null);
            parser.checkAttributes();
            return this.createChangeDefaultValueTrigger(doubleParam, condition, defaultValue);
        }
        if (parameter instanceof BooleanParameter) {
            BooleanParameter booleanParam = (BooleanParameter)parameter;
            Boolean defaultValue = new Boolean(parser.extractAttributeValueAsBoolean(CHANGE_DEFAULT_VALUE_TRIGGER_ELEMENT_NEW_DEFAULT_VALUE_ATTRIBUTE));
            parser.checkAttributes();
            return this.createChangeDefaultValueTrigger(booleanParam, condition, defaultValue);
        }
        if (parameter instanceof EnumerationParameter) {
            EnumerationParameter enumParameter = (EnumerationParameter)parameter;
            EnumerationParameter enumerationParameter = (EnumerationParameter)parameter;
            String itemId = parser.extractAttributeValue(CHANGE_DEFAULT_VALUE_TRIGGER_ELEMENT_NEW_DEFAULT_VALUE_ATTRIBUTE);
            EnumerationItem defaultValue = enumerationParameter.getItem(itemId);
            if (defaultValue == null) {
                throw new ParseException("O item de enumera\u00e7\u00e3o {0} n\u00e3o est\u00e1 presente na enumera\u00e7\u00e3o {1}.", itemId, parameter);
            }
            parser.checkAttributes();
            return this.createChangeDefaultValueTrigger(enumParameter, condition, defaultValue);
        }
        throw new ParseException("O par\u00e2metro {0} n\u00e3o \u00e9 de um tipo v\u00e1lido.\nTipos permitidos:\n{1};\n{2};\n{3};\n{4};\n{5}.", parameterName, "texto", "inteiro", "real", "booleano", "enumeracao");
    }

    private <V> ChangeDefaultValueTrigger<V> createChangeDefaultValueTrigger(SimpleParameter<V> parameter, Condition condition, V defaultValue) {
        return new ChangeDefaultValueTrigger<V>(parameter, condition, defaultValue);
    }

    private ChangeFileTypeTrigger loadChangeFileTypeTrigger(XmlParser parser, SimpleAlgorithmConfigurator configurator) throws ParseException {
        String parameterName = parser.extractAttributeValue("parametro");
        SimpleParameter<?> parameter = configurator.getSimpleParameter(parameterName);
        if (parameter == null) {
            throw new ParseException("O par\u00e2metro {0} que est\u00e1 referenciado no elemento {1} atributo {2} n\u00e3o est\u00e1 definido.", parameterName, CHANGE_MAXIMUM_TRIGGER_ELEMENT, "parametro");
        }
        if (!(parameter instanceof FileParameter)) {
            throw new ParseException("O par\u00e2metro {0} n\u00e3o \u00e9 de um tipo v\u00e1lido.\nTipos permitidos:\n{1};\n{2}.", parameterName, "arquivo_de_entrada", "arquivo_de_saida");
        }
        Condition condition = this.loadTriggerCondition(parser, configurator);
        String newFileType = parser.extractAttributeValue(CHANGE_FILE_TYPE_TRIGGER_ELEMENT_NEW_FILE_TYPE_ATTRIBUTE, null);
        parser.checkAttributes();
        return new ChangeFileTypeTrigger((FileParameter)parameter, condition, newFileType);
    }

    private Trigger<?> loadChangeLabelTrigger(XmlParser parser, SimpleAlgorithmConfigurator configurator) throws ParseException {
        String parameterName = parser.extractAttributeValue("parametro");
        SimpleParameter<?> parameter = configurator.getSimpleParameter(parameterName);
        if (parameter == null) {
            throw new ParseException("O par\u00e2metro {0} que est\u00e1 referenciado no elemento {1} atributo {2} n\u00e3o est\u00e1 definido.", parameterName, CHANGE_LABEL_TRIGGER_ELEMENT, "parametro");
        }
        String newLabel = parser.extractAttributeValue(CHANGE_LABEL_TRIGGER_ELEMENT_NEW_LABEL_ATTRIBUTE);
        Condition condition = this.loadTriggerCondition(parser, configurator);
        parser.checkAttributes();
        return new ChangeLabelTrigger(parameter, condition, newLabel);
    }

    private Trigger<?> loadChangeMaximumTrigger(XmlParser parser, SimpleAlgorithmConfigurator configurator) throws ParseException {
        Trigger trigger;
        String parameterName = parser.extractAttributeValue("parametro");
        SimpleParameter<?> parameter = configurator.getSimpleParameter(parameterName);
        if (parameter == null) {
            throw new ParseException("O par\u00e2metro {0} que est\u00e1 referenciado no elemento {1} atributo {2} n\u00e3o est\u00e1 definido.", parameterName, CHANGE_MAXIMUM_TRIGGER_ELEMENT, "parametro");
        }
        Condition condition = this.loadTriggerCondition(parser, configurator);
        if (parameter instanceof DoubleParameter) {
            Double maximum = parser.extractAttributeValueAsDouble(CHANGE_MAXIMUM_TRIGGER_ELEMENT_NEW_MAXIMUM_ATTRIBUTE, null);
            boolean isMaximumIncluded = parser.extractAttributeValueAsBoolean(CHANGE_MAXIMUM_TRIGGER_ELEMENT_INCLUDE_NEW_MAXIMUM_ATTRIBUTE, true);
            DoubleParameter doubleParameter = (DoubleParameter)parameter;
            trigger = new ChangeMaximumForDoublesTrigger(doubleParameter, condition, maximum, isMaximumIncluded);
        } else if (parameter instanceof DoubleListParameter) {
            Double maximum = parser.extractAttributeValueAsDouble(CHANGE_MAXIMUM_TRIGGER_ELEMENT_NEW_MAXIMUM_ATTRIBUTE, null);
            boolean isMaximumIncluded = parser.extractAttributeValueAsBoolean(CHANGE_MAXIMUM_TRIGGER_ELEMENT_INCLUDE_NEW_MAXIMUM_ATTRIBUTE, true);
            DoubleListParameter doubleListParameter = (DoubleListParameter)parameter;
            trigger = new ChangeMaximumForDoublesTrigger(doubleListParameter, condition, maximum, isMaximumIncluded);
        } else if (parameter instanceof IntegerParameter) {
            Integer maximum = parser.extractAttributeValueAsInteger(CHANGE_MAXIMUM_TRIGGER_ELEMENT_NEW_MAXIMUM_ATTRIBUTE, null);
            IntegerParameter integerParameter = (IntegerParameter)parameter;
            trigger = new ChangeMaximumForIntegersTrigger(integerParameter, condition, maximum);
        } else if (parameter instanceof IntegerListParameter) {
            Integer maximum = parser.extractAttributeValueAsInteger(CHANGE_MAXIMUM_TRIGGER_ELEMENT_NEW_MAXIMUM_ATTRIBUTE, null);
            IntegerListParameter integerListParameter = (IntegerListParameter)parameter;
            trigger = new ChangeMaximumForIntegersTrigger(integerListParameter, condition, maximum);
        } else {
            throw new ParseException("O par\u00e2metro {0} n\u00e3o \u00e9 de um tipo v\u00e1lido.\nTipos permitidos:\n{1};\n{2};\n{3};\n{4}.", parameterName, "real", "lista_de_reais", "inteiro", "lista_de_inteiros");
        }
        parser.checkAttributes();
        return trigger;
    }

    private Trigger<?> loadChangeMinimumTrigger(XmlParser parser, SimpleAlgorithmConfigurator configurator) throws ParseException {
        Trigger trigger;
        String parameterName = parser.extractAttributeValue("parametro");
        SimpleParameter<?> parameter = configurator.getSimpleParameter(parameterName);
        if (parameter == null) {
            throw new ParseException("O par\u00e2metro {0} que est\u00e1 referenciado no elemento {1} atributo {2} n\u00e3o est\u00e1 definido.", parameterName, CHANGE_MINIMUM_TRIGGER_ELEMENT, "parametro");
        }
        Condition condition = this.loadTriggerCondition(parser, configurator);
        if (parameter instanceof DoubleParameter) {
            Double minimum = parser.extractAttributeValueAsDouble(CHANGE_MINIMUM_TRIGGER_ELEMENT_NEW_MINIMUM_ATTRIBUTE, null);
            boolean isMinimumIncluded = parser.extractAttributeValueAsBoolean(CHANGE_MINIMUM_TRIGGER_ELEMENT_INCLUDE_NEW_MINIMUM_ATTRIBUTE, true);
            DoubleParameter doubleParameter = (DoubleParameter)parameter;
            trigger = new ChangeMinimumForDoublesTrigger(doubleParameter, condition, minimum, isMinimumIncluded);
        } else if (parameter instanceof DoubleListParameter) {
            Double minimum = parser.extractAttributeValueAsDouble(CHANGE_MINIMUM_TRIGGER_ELEMENT_NEW_MINIMUM_ATTRIBUTE, null);
            boolean isMinimumIncluded = parser.extractAttributeValueAsBoolean(CHANGE_MINIMUM_TRIGGER_ELEMENT_INCLUDE_NEW_MINIMUM_ATTRIBUTE, true);
            DoubleListParameter doubleListParameter = (DoubleListParameter)parameter;
            trigger = new ChangeMinimumForDoublesTrigger(doubleListParameter, condition, minimum, isMinimumIncluded);
        } else if (parameter instanceof IntegerParameter) {
            Integer minimum = parser.extractAttributeValueAsInteger(CHANGE_MINIMUM_TRIGGER_ELEMENT_NEW_MINIMUM_ATTRIBUTE, null);
            IntegerParameter integerParameter = (IntegerParameter)parameter;
            trigger = new ChangeMinimumForIntegersTrigger(integerParameter, condition, minimum);
        } else if (parameter instanceof IntegerListParameter) {
            Integer minimum = parser.extractAttributeValueAsInteger(CHANGE_MINIMUM_TRIGGER_ELEMENT_NEW_MINIMUM_ATTRIBUTE, null);
            IntegerListParameter integerListParameter = (IntegerListParameter)parameter;
            trigger = new ChangeMinimumForIntegersTrigger(integerListParameter, condition, minimum);
        } else {
            throw new ParseException("O par\u00e2metro {0} n\u00e3o \u00e9 de um tipo v\u00e1lido.\nTipos permitidos:\n{1};\n{2};\n{3};\n{4}..", parameterName, "real", "lista_de_reais", "inteiro", "lista_de_inteiros");
        }
        parser.checkAttributes();
        return trigger;
    }

    private List<DisableParameterTrigger> loadDisableParameterTriggers(XmlParser parser, SimpleAlgorithmConfigurator configurator) throws ParseException {
        Set<SimpleParameter<?>> parameters = this.loadTriggerParameters(parser, configurator);
        Condition condition = this.loadTriggerCondition(parser, configurator);
        parser.checkAttributes();
        LinkedList<DisableParameterTrigger> triggers = new LinkedList<DisableParameterTrigger>();
        for (SimpleParameter<?> parameter : parameters) {
            triggers.add(new DisableParameterTrigger(parameter, condition));
        }
        return Collections.unmodifiableList(triggers);
    }

    private List<EnableParameterTrigger> loadEnableParameterTrigger(XmlParser parser, SimpleAlgorithmConfigurator configurator) throws ParseException {
        Set<SimpleParameter<?>> parameters = this.loadTriggerParameters(parser, configurator);
        Condition condition = this.loadTriggerCondition(parser, configurator);
        parser.checkAttributes();
        LinkedList<EnableParameterTrigger> triggers = new LinkedList<EnableParameterTrigger>();
        for (SimpleParameter<?> parameter : parameters) {
            triggers.add(new EnableParameterTrigger(parameter, condition));
        }
        return Collections.unmodifiableList(triggers);
    }

    private List<HideParameterTrigger> loadHideParameterTriggers(XmlParser parser, SimpleAlgorithmConfigurator configurator) throws ParseException {
        LinkedList<HideParameterTrigger> triggers = new LinkedList<HideParameterTrigger>();
        Condition condition = this.loadTriggerCondition(parser, configurator);
        Set<SimpleParameter<?>> parameters = this.loadTriggerParameters(parser, configurator);
        parser.checkAttributes();
        for (SimpleParameter<?> parameter : parameters) {
            triggers.add(new HideParameterTrigger(parameter, condition));
        }
        return Collections.unmodifiableList(triggers);
    }

    private List<HideGroupTrigger> loadHideGroupTriggers(XmlParser parser, SimpleAlgorithmConfigurator configurator) throws ParseException {
        LinkedList<HideGroupTrigger> triggers = new LinkedList<HideGroupTrigger>();
        Condition condition = this.loadTriggerCondition(parser, configurator);
        Set<ParameterGroup> groups = this.loadTriggerGroups(parser, configurator);
        parser.checkAttributes();
        for (ParameterGroup group : groups) {
            triggers.add(new HideGroupTrigger(group, condition));
        }
        return Collections.unmodifiableList(triggers);
    }
}

