/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.serializer;

import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.flows.configurator.FlowAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.serializer.DefaultAlgorithmConfigurationSerializer;
import csbase.logic.algorithms.serializer.FlowAlgorithmConfigurationSerializer;
import csbase.logic.algorithms.serializer.IAlgorithmConfigurationSerializer;
import java.util.HashMap;
import java.util.Map;

public class AlgorithmConfigurationSerializerFactory {
    private static final IAlgorithmConfigurationSerializer DEFAULT_SERIALIZER = new DefaultAlgorithmConfigurationSerializer();
    private static final Map<Class<?>, IAlgorithmConfigurationSerializer> SERIALIZERS = new HashMap();

    static {
        SERIALIZERS.put(SimpleAlgorithmConfigurator.class, DEFAULT_SERIALIZER);
        SERIALIZERS.put(FlowAlgorithmConfigurator.class, new FlowAlgorithmConfigurationSerializer());
    }

    public static final IAlgorithmConfigurationSerializer getDefaultSerializer() {
        return DEFAULT_SERIALIZER;
    }

    public static final <T extends AlgorithmConfigurator> IAlgorithmConfigurationSerializer getSerializer(Class<T> algConfClass) {
        if (algConfClass == null) {
            throw new IllegalArgumentException("Foi passado null como valor para o par\u00e2metro algConfClass.");
        }
        IAlgorithmConfigurationSerializer serializer = SERIALIZERS.get(algConfClass);
        if (serializer != null) {
            return serializer;
        }
        return AlgorithmConfigurationSerializerFactory.getDefaultSerializer();
    }

    public static IAlgorithmConfigurationSerializer getSerializer(String serializerClassName) {
        if (serializerClassName == null) {
            throw new IllegalArgumentException("Foi passado null como valor para o par\u00e2metro serializerClassName.");
        }
        for (IAlgorithmConfigurationSerializer serializer : SERIALIZERS.values()) {
            if (!serializer.getClass().getName().equals(serializerClassName)) continue;
            return serializer;
        }
        return AlgorithmConfigurationSerializerFactory.getDefaultSerializer();
    }
}

