/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.Column;
import csbase.logic.algorithms.parameters.EnumerationItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class EnumerationColumn
extends Column<EnumerationItem> {
    private List<EnumerationItem> items;

    public EnumerationColumn(String id, String label, EnumerationItem defaultItem, List<EnumerationItem> items) {
        super(id, label, defaultItem, false, true);
        this.setItems(items);
    }

    @Override
    public String getCommandValue(EnumerationItem itemValue) {
        return itemValue.getValue();
    }

    @Override
    public String getItemValueAsText(EnumerationItem itemValue) {
        return itemValue.getId();
    }

    @Override
    public EnumerationItem getItemValueFromText(String itemValue) throws ParseException {
        if (itemValue == null) {
            return null;
        }
        for (EnumerationItem item : this.items) {
            if (!itemValue.equals(item.getId())) continue;
            return item;
        }
        throw new ParseException("O \u00edtem cujo identificador \u00e9 {0} n\u00e3o foi encontrado.", itemValue);
    }

    public List<EnumerationItem> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    @Override
    public Object getValueToExport(EnumerationItem itemValue) {
        if (itemValue == null) {
            return null;
        }
        return itemValue.getId();
    }

    @Override
    public EnumerationItem getValueToImport(Object importedValue) {
        String enumerationItemId = (String)importedValue;
        if (enumerationItemId == null) {
            return null;
        }
        for (EnumerationItem item : this.items) {
            if (!enumerationItemId.equals(item.getId())) continue;
            return item;
        }
        throw new IllegalArgumentException(String.format("O valor %s n\u00e3o \u00e9 v\u00e1lido para a coluna de enumera\u00e7\u00e3o %s.", enumerationItemId, this.getLabel()));
    }

    private void setItems(List<EnumerationItem> items) {
        if (items == null) {
            throw new IllegalArgumentException("O par\u00e2metro items est\u00e1 nulo.");
        }
        if (items.isEmpty()) {
            throw new IllegalArgumentException("O par\u00e2metro items est\u00e1 vazio.");
        }
        this.items = new ArrayList<EnumerationItem>(items);
    }
}

