/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.logic.algorithms.CommandLineBuilder;
import csbase.logic.algorithms.CommandLineContext;
import csbase.logic.algorithms.EnvironmentVariable;
import csbase.logic.algorithms.parameters.AbstractFileParameter;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileParameterPipeAcceptance;
import csbase.logic.algorithms.parameters.FileURLValue;
import csbase.logic.algorithms.parameters.validators.FileParameterValidator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class FileParameter
extends AbstractFileParameter {
    private boolean usesFilter;

    protected FileParameter(String name, String label, String description, FileURLValue defaultValue, boolean isOptional, boolean isVisible, String commandLinePattern, String fileType, FileParameterMode mode, FileParameterPipeAcceptance usesPipe, boolean usesFilter, boolean mustExist) {
        super(name, label, description, defaultValue, isOptional, isVisible, commandLinePattern, fileType, mode, usesPipe, mustExist);
        this.usesFilter = usesFilter;
    }

    @Override
    public Map<String, Object> exportValue() {
        HashMap valuesByName = new HashMap();
        LinkedList exportableValues = new LinkedList();
        FileURLValue file = (FileURLValue)this.getValue();
        if (file != null) {
            HashMap<String, String> exportableValue = new HashMap<String, String>();
            exportableValue.put(".path", file.getPath());
            exportableValue.put(".type", file.getType());
            exportableValues.add(Collections.unmodifiableMap(exportableValue));
            valuesByName.put(this.getName(), Collections.unmodifiableCollection(exportableValues));
        }
        return Collections.unmodifiableMap(valuesByName);
    }

    @Override
    public final String getCommandValue(CommandLineContext context) {
        FileURLValue file = (FileURLValue)this.getValue();
        if (file == null) {
            return null;
        }
        StringBuilder commandValue = new StringBuilder();
        char fileSeparator = context.getFileSeparator();
        if (file.getPath().startsWith("$")) {
            commandValue.append(file.getPath());
        } else {
            String path = file.getPath(fileSeparator);
            commandValue.append(CommandLineBuilder.makePathWithEnvironmentVariable(EnvironmentVariable.PROJECT_DIR, path, fileSeparator));
        }
        return commandValue.toString();
    }

    @Override
    public final String getValueAsText() {
        FileURLValue file = (FileURLValue)this.getValue();
        if (file == null) {
            return null;
        }
        String type = file.getType();
        if (type == null || type.trim().isEmpty()) {
            type = "UNKNOWN";
        }
        String valueAsText = file.getPath() + ":" + type;
        return valueAsText;
    }

    public boolean usesFilter() {
        return this.usesFilter;
    }

    @Override
    public void importValue(Map<String, Object> parameterValues) {
        Collection exportableValues = (Collection)parameterValues.get(this.getName());
        if (exportableValues != null && !exportableValues.isEmpty()) {
            Map exportableValue = (Map)exportableValues.iterator().next();
            String path = (String)exportableValue.get(".path");
            String type = (String)exportableValue.get(".type");
            FileURLValue file = new FileURLValue(path, type);
            this.setValue(file);
        } else {
            this.setValue(null);
        }
    }

    @Override
    public final void setValueAsText(String parameterValue) {
        String type;
        String path;
        if (parameterValue == null || parameterValue.length() == 0) {
            this.setValue(null);
            return;
        }
        Pattern withTypePattern = Pattern.compile("^(.+):(.*)$");
        Matcher withTypeMatcher = withTypePattern.matcher(parameterValue);
        if (withTypeMatcher.matches()) {
            path = withTypeMatcher.group(1);
            type = withTypeMatcher.group(2);
        } else {
            path = parameterValue;
            type = null;
        }
        if (type == null || type.trim().isEmpty()) {
            type = this.mode == FileParameterMode.DIRECTORY ? "DIRECTORY_TYPE" : "UNKNOWN";
        }
        FileURLValue file = new FileURLValue(path, type);
        this.setValue(file);
    }

    public void setUsesFilter(boolean usesFilter) {
        this.usesFilter = usesFilter;
    }

    public FileParameterValidator createParameterValidator() {
        return new FileParameterValidator(this.isOptional());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.listeners = new LinkedList();
    }
}

