/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers;

import csbase.exception.BugException;
import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.FileParameterPipeAcceptance;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parsers.SimpleParameterParser;
import csbase.logic.algorithms.parsers.StringToEnumConverter;
import csbase.logic.algorithms.parsers.XmlParser;

public abstract class AbstractURLParameterParser<T extends SimpleParameter<?>>
extends SimpleParameterParser<T> {
    protected static final String MUST_SORT_ATTRIBUTE = "ordenar";
    protected static final boolean MUST_SORT_DEFAULT_VALUE = true;
    protected static final String CAN_USE_PIPE_ATTRIBUTE = "permitir_pipe";
    protected static final FileParameterPipeAcceptance CAN_USE_PIPE_DEFAULT_VALUE = FileParameterPipeAcceptance.TRUE;
    protected static final String CATEGORY_ATTRIBUTE = "categoria";
    protected static final String CATEGORY_VALUE_DIRECTORY = "diretorio";
    protected static final String CATEGORY_VALUE_REGULAR_FILE = "arquivo";
    protected static final String PROTOCOLS_ATTRIBUTE = "protocolos";
    protected static final String DEFAULT_DIRECTORY_ATTRIBUTE = "usar_diretorio_raiz_como_padrao";
    protected static final boolean DEFAULT_DIRECTORY_DEFAULT_VALUE = false;
    protected static final String TYPE_ATTRIBUTE = "tipo";
    protected static final String LOCALIZATION_ATTRIBUTE = "localizacao";

    protected class URLParameterPipeAcceptanceConverter
    implements StringToEnumConverter<FileParameterPipeAcceptance> {
        protected URLParameterPipeAcceptanceConverter() {
        }

        public String[] getPossibleMatches(FileParameterPipeAcceptance value) {
            switch (value) {
                case TRUE: {
                    return XmlParser.TRUE_VALUES;
                }
                case FALSE: {
                    return XmlParser.FALSE_VALUES;
                }
                case ALWAYS: {
                    return new String[]{"sempre", "always"};
                }
            }
            throw new BugException();
        }

        @Override
        public FileParameterPipeAcceptance valueOf(String string) throws ParseException {
            if (string != null) {
                String upperCaseString = string.toUpperCase();
                for (FileParameterPipeAcceptance mode : FileParameterPipeAcceptance.values()) {
                    String[] possibleMatches;
                    for (String possibleMatch : possibleMatches = this.getPossibleMatches(mode)) {
                        if (!possibleMatch.toUpperCase().equals(upperCaseString)) continue;
                        return mode;
                    }
                }
            }
            throw new ParseException("A string " + string + " n\u00e3o p\u00f4de ser mapeada para um item de enumera\u00e7\u00e3o do tipo " + FileParameterPipeAcceptance.class.getName());
        }
    }
}

