/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.ClientSGAFileParameter;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parsers.SimpleParameterParser;
import csbase.logic.algorithms.parsers.XmlParser;
import java.util.ArrayList;
import java.util.List;

public class ClientSGAFileParameterFactory
extends SimpleParameterParser<ClientSGAFileParameter> {
    private static final String MULTIPLE_SELECTION_ATTRIBUTE = "selecao_multipla";
    private static final String CATEGORY_ATTRIBUTE = "categoria";
    private static final String CATEGORY_ATTRIBUTE_VALUE_REGULAR_FILE = "arquivo";
    private static final String CATEGORY_ATTRIBUTE_VALUE_DIRECTORY = "diretorio";
    private static final String MODE_ATTRIBUTE = "modo";
    private static final String MODE_ATTRIBUTE_VALUE_INPUT = "entrada";
    private static final String MODE_ATTRIBUTE_VALUE_OUTPUT = "saida";
    private static final String TYPE_ATTRIBUTE = "tipo";

    @Override
    public ClientSGAFileParameter createSimpleParameter(XmlParser parser, String name, String label, String description, boolean isOptional, boolean isVisible, String commandLinePattern, ParameterGroup group) throws ParseException {
        ClientSGAFileParameter parameter = new ClientSGAFileParameter(name, label, description, null, isOptional, isVisible, commandLinePattern);
        parameter.setMultipleSelection(this.isMultipleSelection(parser));
        parameter.setShowFiles(this.showFiles(parser));
        parameter.setInputMode(this.isInputMode(parser));
        parameter.setTypes(this.types(parser));
        if (parameter.isMultipleSelection() && !parameter.isInputMode()) {
            throw new ParseException("O par\u00e2metro " + name + " n\u00e3o pode ser configurado simultaneamente para sele\u00e7\u00e3o m\u00faltipla e modo save.");
        }
        return parameter;
    }

    private boolean isMultipleSelection(XmlParser parser) {
        try {
            return parser.extractAttributeValueAsBoolean(MULTIPLE_SELECTION_ATTRIBUTE, false);
        }
        catch (ParseException e) {
            return false;
        }
    }

    private boolean showFiles(XmlParser parser) {
        String category = parser.extractAttributeValue(CATEGORY_ATTRIBUTE, CATEGORY_ATTRIBUTE_VALUE_REGULAR_FILE);
        if (!category.equalsIgnoreCase(CATEGORY_ATTRIBUTE_VALUE_REGULAR_FILE) && !category.equalsIgnoreCase(CATEGORY_ATTRIBUTE_VALUE_DIRECTORY)) {
            category = CATEGORY_ATTRIBUTE_VALUE_REGULAR_FILE;
        }
        return category.equalsIgnoreCase(CATEGORY_ATTRIBUTE_VALUE_REGULAR_FILE);
    }

    private boolean isInputMode(XmlParser parser) {
        String mode = parser.extractAttributeValue(MODE_ATTRIBUTE, MODE_ATTRIBUTE_VALUE_INPUT);
        if (!mode.equalsIgnoreCase(MODE_ATTRIBUTE_VALUE_INPUT) && !mode.equalsIgnoreCase(MODE_ATTRIBUTE_VALUE_OUTPUT)) {
            mode = MODE_ATTRIBUTE_VALUE_INPUT;
        }
        return mode.equalsIgnoreCase(MODE_ATTRIBUTE_VALUE_INPUT);
    }

    private List<String> types(XmlParser parser) {
        String types = parser.extractAttributeValue(TYPE_ATTRIBUTE, "");
        String[] splited = types.split("(?: *),(?: *)?");
        ArrayList<String> result = new ArrayList<String>();
        for (String s : splited) {
            if (s.isEmpty()) continue;
            result.add(s);
        }
        return result;
    }
}

