/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileURLValue;
import csbase.logic.algorithms.parameters.InputURLListParameter;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.URLProtocol;
import csbase.logic.algorithms.parameters.URLProtocolConverter;
import csbase.logic.algorithms.parsers.AbstractURLParameterParser;
import csbase.logic.algorithms.parsers.XmlParser;
import java.util.ArrayList;
import java.util.EnumSet;

public class InputURLListParameterParser
extends AbstractURLParameterParser<InputURLListParameter> {
    @Override
    public InputURLListParameter createSimpleParameter(XmlParser parser, String name, String label, String description, boolean isOptional, boolean isVisible, String commandLinePattern, ParameterGroup group) throws ParseException {
        EnumSet<URLProtocol> allowedProtocols;
        String protocols;
        String type = parser.extractAttributeValue("tipo", null);
        String localization = parser.extractAttributeValue("localizacao");
        String modeName = parser.extractAttributeValue("categoria", "arquivo");
        if (!modeName.equals("diretorio") && !modeName.equals("arquivo")) {
            throw new ParseException("A categoria informada {0} n\u00e3o \u00e9 v\u00e1lida.\nCategorias v\u00e1lidas:\n{1};\n{2}.", modeName, "arquivo", "diretorio");
        }
        FileParameterMode mode = FileParameterMode.DIRECTORY;
        if (modeName.equals("arquivo")) {
            mode = FileParameterMode.REGULAR_FILE;
        }
        boolean useRootDirectoryAsDefault = parser.extractAttributeValueAsBoolean("usar_diretorio_raiz_como_padrao", false);
        ArrayList<FileURLValue> defaultValue = null;
        if (useRootDirectoryAsDefault) {
            if (mode == FileParameterMode.REGULAR_FILE) {
                throw new ParseException("O atributo {0} \u00e9 inv\u00e1lido quando o par\u00e2metro de entrada \u00e9 um arquivo.", "usar_diretorio_raiz_como_padrao");
            }
            defaultValue = new ArrayList<FileURLValue>();
            defaultValue.add(new FileURLValue("."));
        }
        if ((protocols = parser.extractAttributeValue("protocolos", null)) != null) {
            allowedProtocols = EnumSet.noneOf(URLProtocol.class);
            String[] protocolsAsArray = protocols.split(",");
            URLProtocolConverter converter = new URLProtocolConverter();
            for (String protocolString : protocolsAsArray) {
                URLProtocol protocol = converter.valueOf(protocolString);
                allowedProtocols.add(protocol);
            }
        } else {
            allowedProtocols = EnumSet.allOf(URLProtocol.class);
        }
        boolean mustSort = parser.extractAttributeValueAsBoolean("ordenar", true);
        return new InputURLListParameter(name, label, description, defaultValue, isOptional, isVisible, commandLinePattern, localization, type, mode, mustSort, allowedProtocols);
    }
}

