/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.BooleanColumn;
import csbase.logic.algorithms.parameters.Column;
import csbase.logic.algorithms.parameters.DoubleColumn;
import csbase.logic.algorithms.parameters.EnumerationColumn;
import csbase.logic.algorithms.parameters.EnumerationItem;
import csbase.logic.algorithms.parameters.IntegerColumn;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.TableParameter;
import csbase.logic.algorithms.parameters.TextColumn;
import csbase.logic.algorithms.parsers.EnumerationParameterParser;
import csbase.logic.algorithms.parsers.SimpleParameterParser;
import csbase.logic.algorithms.parsers.XmlParser;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class TableParameterFactory
extends SimpleParameterParser<TableParameter> {
    static final String TABLE_PARAMETER_ELEMENT = "tabela";
    protected static final String TABLE_PARAMETER_ELEMENT_DELIMIT_ROWS_ATTRIBUTE = "delimitar_linhas";
    protected static final boolean TABLE_PARAMETER_ELEMENT_DELIMIT_ROWS_DEFAULT_VALUE = false;
    protected static final String TABLE_PARAMETER_ELEMENT_DELIMIT_TABLE_ATTRIBUTE = "delimitar_tabela";
    protected static final boolean TABLE_PARAMETER_ELEMENT_DELIMIT_TABLE_DEFAULT_VALUE = false;
    protected static final String TABLE_PARAMETER_ELEMENT_VISIBLE_ROW_COUNT_ATTRIBUTE = "quantidade_de_linhas_visiveis";
    protected static final String TABLE_PARAMETER_ELEMENT_MAX_ROW_COUNT_ATTRIBUTE = "quantidade_maxima_de_linhas";
    protected static final String TABLE_PARAMETER_ELEMENT_MIN_ROW_COUNT_ATTRIBUTE = "quantidade_minima_de_linhas";
    protected static final int TABLE_PARAMETER_ELEMENT_ROW_COUNT_MINIMUM_VALUE = 1;
    protected static final String TABLE_PARAMETER_ELEMENT_ROW_COUNT_ATTRIBUTE = "quantidade_de_linhas";
    protected static final String CELL_VALUE_ELEMENT = "celula";
    protected static final String CELL_VALUE_ELEMENT_COLUMN_ID_ATTRIBUTE = "id_da_coluna";
    protected static final String CELL_VALUE_ELEMENT_ROW_INDEX_ATTRIBUTE = "indice_da_linha";
    protected static final String CELL_VALUE_ELEMENT_VALUE_ATTRIBUTE = "valor";
    protected static final String COLUMN_ELEMENT_DEFAULT_VALUE_ATTRIBUTE = "padrao";
    protected static final String COLUMN_ELEMENT_ID_ATTRIBUTE = "id";
    protected static final String COLUMN_ELEMENT_IS_EDITABLE_ATTRIBUTE = "editavel";
    protected static final boolean COLUMN_ELEMENT_IS_EDITABLE_DEFAULT_VALUE = true;
    protected static final String COLUMN_ELEMENT_IS_OPTIONAL_ATTRIBUTE = "opcional";
    protected static final boolean COLUMN_ELEMENT_IS_OPTIONAL_DEFAULT_VALUE = false;
    protected static final String COLUMN_ELEMENT_LABEL_ATTRIBUTE = "rotulo";
    protected static final String BOOLEAN_COLUMN_ELEMENT = "coluna_de_booleanos";
    protected static final String DOUBLE_COLUMN_ELEMENT = "coluna_de_reais";
    protected static final String ENUMERATION_COLUMN_ELEMENT = "coluna_de_enumeracao";
    protected static final String INTEGER_COLUMN_ELEMENT = "coluna_de_inteiros";
    protected static final String TEXT_COLUMN_ELEMENT = "coluna_de_texto";

    @Override
    public TableParameter createSimpleParameter(XmlParser parser, String name, String label, String description, boolean isOptional, boolean isVisible, String commandLinePattern, ParameterGroup group) throws ParseException {
        boolean delimitTable = parser.extractAttributeValueAsBoolean(TABLE_PARAMETER_ELEMENT_DELIMIT_TABLE_ATTRIBUTE, false);
        boolean delimitRows = parser.extractAttributeValueAsBoolean(TABLE_PARAMETER_ELEMENT_DELIMIT_ROWS_ATTRIBUTE, false);
        Integer rowCount = parser.extractAttributeValueAsInteger(TABLE_PARAMETER_ELEMENT_ROW_COUNT_ATTRIBUTE, null, null, 1);
        Integer visibleRowCount = parser.extractAttributeValueAsInteger(TABLE_PARAMETER_ELEMENT_VISIBLE_ROW_COUNT_ATTRIBUTE, null, null, 1);
        Integer maxRowCount = parser.extractAttributeValueAsInteger(TABLE_PARAMETER_ELEMENT_MAX_ROW_COUNT_ATTRIBUTE, null, null, null);
        Integer minRowCount = parser.extractAttributeValueAsInteger(TABLE_PARAMETER_ELEMENT_MIN_ROW_COUNT_ATTRIBUTE, null, null, null);
        List<Column<?>> columns = this.loadColumns(parser);
        this.loadCellValues(parser, columns);
        TableParameter parameter = new TableParameter(name, label, description, isOptional, isVisible, commandLinePattern, columns, delimitTable, delimitRows, rowCount, visibleRowCount, minRowCount, maxRowCount);
        return parameter;
    }

    protected void loadCellValues(XmlParser parser, List<Column<?>> columns) throws ParseException {
        if (parser.goToFirstChild(CELL_VALUE_ELEMENT)) {
            do {
                Object cellValue;
                Integer rowIndex = parser.extractAttributeValueAsInteger(CELL_VALUE_ELEMENT_ROW_INDEX_ATTRIBUTE, null, 0);
                String columnId = parser.extractAttributeValue(CELL_VALUE_ELEMENT_COLUMN_ID_ATTRIBUTE);
                Column<?> theColumn = null;
                for (Column<?> aColumn : columns) {
                    if (!aColumn.getId().equals(columnId)) continue;
                    theColumn = aColumn;
                    break;
                }
                if (theColumn == null) {
                    throw new ParseException("A coluna {0} n\u00e3o encontrada.", columnId);
                }
                if (theColumn instanceof TextColumn) {
                    TextColumn textColumn = (TextColumn)theColumn;
                    cellValue = parser.extractAttributeValue(CELL_VALUE_ELEMENT_VALUE_ATTRIBUTE, null);
                    textColumn.addDefaultValue(rowIndex, cellValue);
                    continue;
                }
                if (theColumn instanceof DoubleColumn) {
                    DoubleColumn doubleColumn = (DoubleColumn)theColumn;
                    cellValue = parser.extractAttributeValueAsDouble(CELL_VALUE_ELEMENT_VALUE_ATTRIBUTE, null, doubleColumn.getMaximum(), doubleColumn.getMinimum());
                    doubleColumn.addDefaultValue(rowIndex, cellValue);
                    continue;
                }
                if (theColumn instanceof IntegerColumn) {
                    IntegerColumn integerColumn = (IntegerColumn)theColumn;
                    cellValue = parser.extractAttributeValueAsInteger(CELL_VALUE_ELEMENT_VALUE_ATTRIBUTE, null, integerColumn.getMaximum(), integerColumn.getMinimum());
                    integerColumn.addDefaultValue(rowIndex, cellValue);
                    continue;
                }
                if (theColumn instanceof BooleanColumn) {
                    BooleanColumn booleanColumn = (BooleanColumn)theColumn;
                    boolean cellValue2 = parser.extractAttributeValueAsBoolean(CELL_VALUE_ELEMENT_VALUE_ATTRIBUTE);
                    booleanColumn.addDefaultValue(rowIndex, cellValue2);
                    continue;
                }
                throw new ParseException(String.format("Foi solicitado que o valor-padr\u00e3o da c\u00e9lula cuja linha \u00e9 %d e a coluna \u00e9 %s fosse modificada.\nPor\u00e9m o tipo desta coluna n\u00e3o suporta este tipo de opera\u00e7\u00e3o.\n", rowIndex, columnId));
            } while (parser.goToNextSibling(CELL_VALUE_ELEMENT));
            parser.goToParent();
        }
    }

    protected List<Column<?>> loadColumns(XmlParser parser) throws ParseException {
        LinkedList columns = new LinkedList();
        if (!parser.goToFirstChild()) {
            throw new ParseException("A lista de colunas da tabela est\u00e1 vazia.");
        }
        do {
            Column column = null;
            String elementName = parser.getElementName();
            if (elementName.equals(BOOLEAN_COLUMN_ELEMENT)) {
                column = this.loadBooleanColumn(parser);
            } else if (elementName.equals(DOUBLE_COLUMN_ELEMENT)) {
                column = this.loadDoubleColumn(parser);
            } else if (elementName.equals(INTEGER_COLUMN_ELEMENT)) {
                column = this.loadIntegerColumn(parser);
            } else if (elementName.equals(TEXT_COLUMN_ELEMENT)) {
                column = this.loadTextColumn(parser);
            } else if (elementName.equals(ENUMERATION_COLUMN_ELEMENT)) {
                column = this.loadEnumerationColumn(parser);
            }
            if (column == null) continue;
            if (columns.contains(column)) {
                throw new ParseException("J\u00e1 existe uma coluna {0}.", column);
            }
            columns.add(column);
        } while (parser.goToNextSibling());
        parser.goToParent();
        return columns;
    }

    protected BooleanColumn loadBooleanColumn(XmlParser parser) throws ParseException {
        String label = parser.extractAttributeValue(COLUMN_ELEMENT_LABEL_ATTRIBUTE);
        String id = parser.extractAttributeValue(COLUMN_ELEMENT_ID_ATTRIBUTE, label);
        String falseCommand = parser.extractAttributeValue("falso", null);
        String trueCommand = parser.extractAttributeValue("verdadeiro", null);
        boolean defaultValue = parser.extractAttributeValueAsBoolean(COLUMN_ELEMENT_DEFAULT_VALUE_ATTRIBUTE, false);
        boolean isEditable = parser.extractAttributeValueAsBoolean(COLUMN_ELEMENT_IS_EDITABLE_ATTRIBUTE, true);
        parser.checkAttributes();
        parser.checkChildElements();
        return new BooleanColumn(id, label, defaultValue, isEditable, falseCommand, trueCommand);
    }

    private DoubleColumn loadDoubleColumn(XmlParser parser) throws ParseException {
        String label = parser.extractAttributeValue(COLUMN_ELEMENT_LABEL_ATTRIBUTE);
        String id = parser.extractAttributeValue(COLUMN_ELEMENT_ID_ATTRIBUTE, label);
        Double defaultValue = parser.extractAttributeValueAsDouble(COLUMN_ELEMENT_DEFAULT_VALUE_ATTRIBUTE, null);
        boolean isOptional = parser.extractAttributeValueAsBoolean(COLUMN_ELEMENT_IS_OPTIONAL_ATTRIBUTE, false);
        boolean isEditable = parser.extractAttributeValueAsBoolean(COLUMN_ELEMENT_IS_EDITABLE_ATTRIBUTE, true);
        Double maximum = parser.extractAttributeValueAsDouble("maximo", null, null, null);
        boolean isMaximumIncluded = parser.extractAttributeValueAsBoolean("incluir_maximo", true);
        Double minimum = parser.extractAttributeValueAsDouble("minimo", null, maximum, null);
        boolean isMinimumIncluded = parser.extractAttributeValueAsBoolean("incluir_minimo", true);
        parser.checkAttributes();
        parser.checkChildElements();
        return new DoubleColumn(id, label, defaultValue, isOptional, isEditable, maximum, isMaximumIncluded, minimum, isMinimumIncluded);
    }

    private EnumerationColumn loadEnumerationColumn(XmlParser parser) throws ParseException {
        String label = parser.extractAttributeValue(COLUMN_ELEMENT_LABEL_ATTRIBUTE);
        String id = parser.extractAttributeValue(COLUMN_ELEMENT_ID_ATTRIBUTE, label);
        String defaultItemId = parser.extractAttributeValue(COLUMN_ELEMENT_DEFAULT_VALUE_ATTRIBUTE);
        LinkedList<EnumerationItem> items = new LinkedList<EnumerationItem>();
        if (!parser.goToFirstChild("item_de_enumeracao")) {
            throw new ParseException("N\u00e3o foram informados os itens da coluna de enumera\u00e7\u00e3o {0}.", label);
        }
        EnumerationParameterParser enumerationParser = new EnumerationParameterParser();
        do {
            EnumerationItem enumerationItem;
            if (items.contains(enumerationItem = enumerationParser.loadEnumerationItem(parser))) {
                throw new ParseException("O item {0} est\u00e1 duplicado na coluna de enumera\u00e7\u00e3o {1}.", enumerationItem.getId(), label);
            }
            for (EnumerationItem item : items) {
                if (!enumerationItem.getLabel().equals(item.getLabel())) continue;
                throw new ParseException("O item {0} est\u00e1 duplicado na coluna de enumera\u00e7\u00e3o {1}.", enumerationItem.getLabel(), label);
            }
            items.add(enumerationItem);
        } while (parser.goToNextSibling("item_de_enumeracao"));
        parser.goToParent();
        boolean mustSort = parser.extractAttributeValueAsBoolean("ordenar", true);
        if (mustSort) {
            Collections.sort(items);
        }
        parser.checkAttributes();
        EnumerationItem defaultItem = enumerationParser.getEnumerationItem(defaultItemId, items, defaultItemId);
        return new EnumerationColumn(id, label, defaultItem, items);
    }

    private IntegerColumn loadIntegerColumn(XmlParser parser) throws ParseException {
        String label = parser.extractAttributeValue(COLUMN_ELEMENT_LABEL_ATTRIBUTE);
        String id = parser.extractAttributeValue(COLUMN_ELEMENT_ID_ATTRIBUTE, label);
        boolean isOptional = parser.extractAttributeValueAsBoolean(COLUMN_ELEMENT_IS_OPTIONAL_ATTRIBUTE, false);
        boolean isEditable = parser.extractAttributeValueAsBoolean(COLUMN_ELEMENT_IS_EDITABLE_ATTRIBUTE, true);
        Integer maximum = parser.extractAttributeValueAsInteger("maximo", null, null, null);
        Integer minimum = parser.extractAttributeValueAsInteger("minimo", null, maximum, null);
        Integer defaultValue = parser.extractAttributeValueAsInteger(COLUMN_ELEMENT_DEFAULT_VALUE_ATTRIBUTE, null, maximum, minimum);
        parser.checkAttributes();
        parser.checkChildElements();
        return new IntegerColumn(id, label, defaultValue, isOptional, isEditable, maximum, minimum);
    }

    private TextColumn loadTextColumn(XmlParser parser) throws ParseException {
        String label = parser.extractAttributeValue(COLUMN_ELEMENT_LABEL_ATTRIBUTE);
        String id = parser.extractAttributeValue(COLUMN_ELEMENT_ID_ATTRIBUTE, label);
        String defaultValue = parser.extractAttributeValue(COLUMN_ELEMENT_DEFAULT_VALUE_ATTRIBUTE, null);
        boolean isOptional = parser.extractAttributeValueAsBoolean(COLUMN_ELEMENT_IS_OPTIONAL_ATTRIBUTE, false);
        boolean isEditable = parser.extractAttributeValueAsBoolean(COLUMN_ELEMENT_IS_EDITABLE_ATTRIBUTE, true);
        Integer maxCharacters = parser.extractAttributeValueAsInteger("maximo_de_caracteres", null, null, 1);
        parser.checkAttributes();
        parser.checkChildElements();
        return new TextColumn(id, label, defaultValue, isOptional, isEditable, maxCharacters);
    }
}

