package csbase.exception;

/**
 * A classe <code>PermissionException</code> representa uma falha
 * durante a execuo de um pedido de servio, devido  falta de 
 * privilgio do usurio que efetuou sua solicitao.
 *
 * Esse tipo de falha pode ou no estar associada a uma descrio especfica.
 * Se houver descrio, a mesma deve ser adequada para exibio ao usurio.
 */
public class PermissionException extends CSBaseRuntimeException {

  /**
   * Constri uma exceo sem descrio nem causa associadas.
   */
  public PermissionException() {
    super();
  }

  /**
   * Constri uma exceo contendo a descrio do erro correspondente.
   * @param message a descrio do erro
   */
  public PermissionException(String message) {
    super(message);
  }
}
