package csbase.logic.algorithms;

import java.text.MessageFormat;

/**
 * Formatador de linha de comando.
 * @author Tecgraf/PUC-Rio
 */
public final class CommandLineParameterFormatter {

  /**
   * Formatao.
   * @param parameterName nome do parmetro
   * @param parameterValue valor do parmetro
   * @param commandLinePattern pattern para gerao
   * @return o comando.
   */
  public static String formatCommandLine(final String parameterName,
    final String parameterValue, final String commandLinePattern) {
    String cmdPatt = commandLinePattern;
    if ((parameterValue == null) || (cmdPatt == null)) {
      return null;
    }
    String[] variables = new String[] { "$NOME_DO_PARAMETRO",
        "$VALOR_DO_PARAMETRO" };
    for (int i = 0; i < variables.length; i++) {
      String format = "{" + i + "}";
      cmdPatt = cmdPatt.replace(variables[i], format);
    }
    return MessageFormat.format(cmdPatt, new Object[] {
        parameterName, parameterValue });
  }

}
