/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.server;

import csbase.logic.ServerURI;
import csbase.logic.server.ServerInfoData;
import java.io.Serializable;
import java.security.cert.Certificate;

public final class ServerInfo
implements Serializable,
Comparable<ServerInfo> {
    private Integer id;
    private String name;
    private boolean suspended;
    private boolean isLocal;
    private ServerURI uri;
    private boolean completed;
    private transient Certificate certificate;

    public ServerInfo(Integer id, String name, boolean suspended, boolean isLocal, ServerURI uri) {
        if (id == null) {
            throw new IllegalArgumentException("Identificador do servidor n\u00e3o pode ser nulo.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Nome do servidor n\u00e3o pode ser nulo.");
        }
        if (uri == null) {
            throw new IllegalArgumentException("A URI n\u00e3o pode ser nula");
        }
        this.id = id;
        this.name = name;
        this.suspended = suspended;
        this.completed = false;
        this.isLocal = isLocal;
        this.uri = uri;
    }

    private ServerInfo(Integer id, String name, boolean suspended, boolean isLocal, ServerURI uri, Certificate certificate) {
        this(id, name, suspended, isLocal, uri);
        if (certificate == null) {
            throw new IllegalArgumentException("O certificado do servidor n\u00e3o pode ser nulo.");
        }
        this.certificate = certificate;
        this.completed = true;
    }

    public ServerInfo(ServerInfo serverInfo) {
        this(serverInfo.id, serverInfo.name, serverInfo.suspended, serverInfo.isLocal, serverInfo.uri);
    }

    public ServerInfo(Integer id, ServerInfoData serverInfo) {
        this(id, serverInfo.getName(), serverInfo.isSuspended(), serverInfo.isLocal(), serverInfo.getURI());
    }

    public ServerInfo(ServerInfo serverInfo, Certificate certificate) {
        this(serverInfo.id, serverInfo.name, serverInfo.suspended, serverInfo.isLocal, serverInfo.getURI(), certificate);
    }

    public ServerInfo(Integer id, ServerInfoData serverInfoData, Certificate certificate) {
        this(id, serverInfoData.getName(), serverInfoData.isSuspended(), serverInfoData.isLocal(), serverInfoData.getURI(), certificate);
    }

    public String getName() {
        return this.name;
    }

    public Object getId() {
        return this.id;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public Certificate getCertificate() {
        return this.certificate;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public ServerURI getURI() {
        return this.uri;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!this.getClass().equals(object.getClass())) {
            return false;
        }
        ServerInfo localServer = (ServerInfo)object;
        return this.name.equals(localServer.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.uri.toString();
    }

    @Override
    public int compareTo(ServerInfo other) {
        return this.name.compareTo(other.name);
    }
}

