/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.serializer;

import csbase.exception.ParseException;
import csbase.exception.algorithms.AlgorithmNotFoundException;
import csbase.exception.algorithms.ParameterNotFoundException;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.parameters.FileURLValue;
import csbase.logic.algorithms.serializer.IAlgorithmConfigurationSerializer;
import csbase.logic.algorithms.serializer.exception.AlgorithmConfigurationSerializerException;
import csbase.logic.algorithms.serializer.exception.AlgorithmConfigurationSerializerIOException;
import csbase.logic.algorithms.serializer.exception.AlgorithmConfigurationSerializerParameterNotFoundException;
import csbase.logic.algorithms.serializer.exception.AlgorithmConfigurationSerializerParseException;
import csbase.remote.ClientRemoteLocator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class DefaultAlgorithmConfigurationSerializer
implements IAlgorithmConfigurationSerializer {
    private static final String ENCODING = "ISO-8859-1";
    private static final Charset CHARSET = Charset.forName("ISO-8859-1");
    private static final String ALGORITHM_CONFIGURATOR_XML_TEMPLATE = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<algoritmo nome='%1$s' versao='%2$s'>\n%3$s%4$s%5$s</algoritmo>";
    private static final String PARAMETER_XML_TEMPLATE = "\t<parametro nome='%1$s'>\n\t\t<valor>\n\t\t\t<![CDATA[%2$s]]>\n\t\t</valor>\n\t</parametro>\n";
    private static final String PARAMETER_NULL_XML_TEMPLATE = "\t<parametro nome='%1$s'>\n\t</parametro>\n";
    private static final String STDOUT_XML_TEMPLATE = "\t<stdout tipo='%1$s'>\n\t\t<![CDATA[%2$s]]>\n\t</stdout>\n";
    private static final String EXIT_CODE_XML_TEMPLATE = "\t<exitcode tipo='%1$s'>\n\t\t<![CDATA[%2$s]]>\n\t</exitcode>\n";

    @Override
    public AlgorithmConfigurator read(InputStream input) throws AlgorithmConfigurationSerializerParseException, AlgorithmConfigurationSerializerIOException, AlgorithmConfigurationSerializerException, AlgorithmNotFoundException {
        if (null == input) {
            throw new IllegalArgumentException();
        }
        String algorithmName = null;
        AlgorithmVersionId algorithmVersionId = null;
        String parameterName = null;
        try {
            Element exitCodeElement;
            String exitCodeFilePath;
            NodeList exitCode;
            Element stdOutElement;
            String outputFilePath;
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputSource source = new InputSource(input);
            source.setEncoding(ENCODING);
            Document document = builder.parse(source);
            Element algorithmElement = document.getDocumentElement();
            algorithmName = algorithmElement.getAttribute("nome");
            String algorithmVersion = algorithmElement.getAttribute("versao");
            algorithmVersionId = AlgorithmVersionId.create(algorithmVersion);
            AlgorithmConfigurator configurator = ClientRemoteLocator.algorithmService.createAlgorithmConfigurator(algorithmName, algorithmVersionId);
            NodeList parameters = algorithmElement.getElementsByTagName("parametro");
            for (int index = 0; index < parameters.getLength(); ++index) {
                Element parameterElement = (Element)parameters.item(index);
                parameterName = parameterElement.getAttribute("nome");
                String parameterValue = null;
                NodeList parameterValueList = parameterElement.getElementsByTagName("valor");
                if (null != parameterValueList && 0 < parameterValueList.getLength()) {
                    Element parameterValueElement = (Element)parameterValueList.item(0);
                    parameterValue = parameterValueElement.getTextContent().trim();
                }
                configurator.setParameterValue(parameterName, parameterValue);
            }
            NodeList stdOut = algorithmElement.getElementsByTagName("stdout");
            if (0 < stdOut.getLength() && null != (outputFilePath = (stdOutElement = (Element)stdOut.item(0)).getTextContent()) && !"".equals(outputFilePath = outputFilePath.trim())) {
                String type = stdOutElement.getAttribute("tipo");
                type = null == type || "".equals(type.trim()) ? "LOG" : type.trim();
                FileURLValue outputFile = new FileURLValue(outputFilePath, type);
                configurator.setStandardOutputFile(outputFile);
            }
            if (0 < (exitCode = algorithmElement.getElementsByTagName("exitcode")).getLength() && null != (exitCodeFilePath = (exitCodeElement = (Element)exitCode.item(0)).getTextContent()) && !"".equals(exitCodeFilePath = exitCodeFilePath.trim())) {
                String type = exitCodeElement.getAttribute("tipo");
                type = null == type || "".equals(type.trim()) ? "LOG" : type.trim();
                FileURLValue exitCodeFile = new FileURLValue(exitCodeFilePath, type);
                configurator.setExitCodeLogFile(exitCodeFile);
                configurator.setHasExitCode(true);
            }
            return configurator;
        }
        catch (RemoteException e) {
            throw new AlgorithmConfigurationSerializerException(e);
        }
        catch (ParameterNotFoundException e) {
            throw new AlgorithmConfigurationSerializerParameterNotFoundException(e, algorithmName, algorithmVersionId, parameterName);
        }
        catch (ParseException e) {
            throw new AlgorithmConfigurationSerializerParseException(e);
        }
        catch (ParserConfigurationException e) {
            throw new AlgorithmConfigurationSerializerParseException(e);
        }
        catch (SAXException e) {
            throw new AlgorithmConfigurationSerializerParseException(e);
        }
        catch (IOException e) {
            throw new AlgorithmConfigurationSerializerIOException(e);
        }
    }

    @Override
    public void write(AlgorithmConfigurator configurator, OutputStream output) throws AlgorithmConfigurationSerializerException {
        if (null == configurator) {
            throw new IllegalArgumentException();
        }
        if (null == output) {
            throw new IllegalArgumentException();
        }
        String parameterName = null;
        try {
            StringBuilder parameters = new StringBuilder();
            Set<String> parameterNames = configurator.getParameterNames();
            Iterator<String> i$ = parameterNames.iterator();
            while (i$.hasNext()) {
                String aParameterName;
                parameterName = aParameterName = i$.next();
                String aParameterValue = configurator.getParameterValue(aParameterName);
                String parameterXml = null == aParameterValue ? String.format(PARAMETER_NULL_XML_TEMPLATE, aParameterName) : String.format(PARAMETER_XML_TEMPLATE, aParameterName, aParameterValue);
                parameters.append(parameterXml);
            }
            String stdOut = null == configurator.getStandardOutputFile() ? "" : String.format(STDOUT_XML_TEMPLATE, configurator.getStandardOutputFile().getType(), configurator.getStandardOutputFile().getPath());
            String exitCode = !configurator.hasExitCode() || null == configurator.getExitCodeLogFile() ? "" : String.format(EXIT_CODE_XML_TEMPLATE, configurator.getExitCodeLogFile().getType(), configurator.getExitCodeLogFile().getPath());
            String algorithmConfiguratorXml = String.format(ALGORITHM_CONFIGURATOR_XML_TEMPLATE, configurator.getAlgorithmName(), configurator.getAlgorithmVersionId().toString(), parameters.toString(), stdOut, exitCode);
            PrintWriter writer = new PrintWriter(new OutputStreamWriter(output, CHARSET));
            writer.write(algorithmConfiguratorXml);
            writer.flush();
        }
        catch (ParameterNotFoundException e) {
            throw new AlgorithmConfigurationSerializerParameterNotFoundException(e, configurator.getAlgorithmName(), configurator.getAlgorithmVersionId(), parameterName);
        }
    }
}

