/*
 * Detalhes da ltima alterao:
 * 
 * $Author: rodrigoh $
 * $Date$
 * $Revision: 66864 $
 */
package csbase.logic;

import java.io.Serializable;
import java.net.URL;

/**
 * Dados sobre um <i>preLogin</i> realizado com sucesso.
 * 
 * @author Tecgraf/PUC-Rio
 */
public final class PreLoginData implements Serializable {
  /**
   * O <i>token</i> gerado pelo {@code preLogin}.
   */
  private String token;
  /**
   * A chave de sesso do usurio
   */
  private Object sessionKey;
  /**
   * A URL para <i>login</i> no sistema.
   */
  private URL url2Login;

  /**
   * Agrupa os dados sobre um <i>preLogin</i> realizado no sistema.
   * 
   * @param sessionKey A chave de sesso do usurio.
   * @param token O <i>token</i> gerado pelo {@code preLogin}.
   */
  public PreLoginData(Object sessionKey, String token) {
    this.sessionKey = sessionKey;
    this.token = token;
  }

  /**
   * Obtm o <i>token</i> gerado pelo {@code preLogin}.
   * 
   * @return O <i>token</i> gerado pelo {@code preLogin}.
   */
  public String getToken() {
    return this.token;
  }

  /**
   * Obtm a chave de sesso do usurio.
   * 
   * @return A chave de sesso do usurio.
   */
  public Object getSessionKey() {
    return this.sessionKey;
  }

  /**
   * Obtm a URL para <i>login</i> no sistema.
   * 
   * @return A URL para <i>login</i> no sistema.
   */
  public URL getUrl2Login() {
    return this.url2Login;
  }

  /**
   * Define a URL para <i>login</i> no sistema.
   * 
   * @param url2Login A URL para <i>login</i> no sistema.
   */
  public void setUrl2Login(URL url2Login) {
    this.url2Login = url2Login;
  }
}
