package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.BooleanColumn;
import csbase.logic.algorithms.parameters.BooleanParameter;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.TableParameter;

/**
 * <p>
 * Analisador de {@link BooleanParameter}.
 * </p>
 * 
 * <p>
 * Este parser l os atributos de parmetros do tipo booleano. O elemento
 * corrente do {@link XmlParser analisador de XML} precisa ser um elemento
 * {@link BooleanParameter}.
 * </p>
 */
public class BooleanParameterFactory extends
  SimpleParameterParser<BooleanParameter> {

  /**
   * <p>
   * O elemento {@value #BOOLEAN_PARAMETER_ELEMENT}: descreve as propriedades de
   * um {@link BooleanParameter parmetro do tipo booleano}.
   * </p>
   * <p>
   *  filho do elemento {@link ParameterGroup}.
   * </p>
   */
  public static final String BOOLEAN_PARAMETER_ELEMENT = "booleano";

  /**
   * O atributo {@value #BOOLEAN_ELEMENT_FALSE_ATTRIBUTE} do elemento
   * {@link BooleanColumn} de um {@link TableParameter} ou
   * {@link BooleanParameter}: define o valor a ser utilizado na linha de
   * comando, quando o valor de uma clula da coluna for falso ou quando o valor
   * do parmetro for falso,  opcional e  do tipo string.
   */
  public static final String BOOLEAN_ELEMENT_FALSE_ATTRIBUTE = "falso";

  /**
   * O atributo {@value #BOOLEAN_ELEMENT_TRUE_ATTRIBUTE} do elemento
   * {@link BooleanColumn} de um {@link TableParameter} ou
   * {@link BooleanParameter}: define o valor a ser utilizado na linha de
   * comando, quando o valor de uma clula da coluna for verdadeiro ou quando o
   * valor do parmetro for verdadeiro,  opcional e  do tipo string.
   */
  public static final String BOOLEAN_ELEMENT_TRUE_ATTRIBUTE = "verdadeiro";

  /**
   * {@inheritDoc}
   */
  @Override
  public BooleanParameter createSimpleParameter(XmlParser parser, String name,
    String label, String description, boolean isOptional, boolean isVisible,
    String commandLinePattern, ParameterGroup group,
    SimpleAlgorithmConfigurator configurator) throws ParseException {
    boolean defaultValue = parser.extractAttributeValueAsBoolean(
      PARAMETER_ELEMENT_DEFAULT_VALUE_ATTRIBUTE, false);
    String falseCommand = parser.extractAttributeValue(
      BOOLEAN_ELEMENT_FALSE_ATTRIBUTE, null);
    String trueCommand = parser.extractAttributeValue(
      BOOLEAN_ELEMENT_TRUE_ATTRIBUTE, null);
    return new BooleanParameter(name, label, description, defaultValue,
      isVisible, commandLinePattern, falseCommand, trueCommand);
  }

}
