package csbase.logic.applicationservice;

import csbase.logic.Notification;

/**
 * A classe <code>ApplicationEvent</code> representa uma notificao da recarga
 * das aplicaes no servidor.
 */
public class ApplicationsReloadNotification extends Notification {

  /**
   * Constri o evento de notificao.
   * 
   * @param sender Quem est enviando a notificao (no pode ser {@code null}).
   */
  public ApplicationsReloadNotification(String sender) {
    super(sender, true, false);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean isVolatile() {
    return true;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String toString() {
    return "APPLICATIONS RELOAD / NOTIFICATION";
  }

}
