package csbase.logic.url;

/**
 * Constantes que definem os parmetros das URLs dos sistemas CSBASE.
 *
 * @author Tecgraf/PUC-Rio
 */
public class URLParameters {

  /**
   * Identificador do sistema chamador da sesso. Esse parmetro poder usado na
   * confirmao de acesso pelo outro sistema pelo servio de sesso do Openbus.
   */
  public static final String SESSION_CALLER_PARAMETER =
    "session_caller_identifier";

  /**
   * O nome do parmetro que define o endereo da mquina onde o cliente est
   * rodando.
   */
  public static final String CLIENT_ADDRESS_PARAMETER = "client_address";

  /**
   * O nome do parmetro que define o token de indentificao de um usurio que
   * realizou pr-login antes de carregar o cliente do sistema.
   */
  public static final String PRE_LOGIN_TOKEN_PARAMETER = "token";

  /**
   * O nome do parmetro que define o locale que o usurio deseja carregar o
   * sistema.
   */
  public static final String LOCALE_PARAMETER = "locale";

  /**
   * O nome do parmetro que define uma aplicao a ser iniciada quando o login
   * for efetuado.
   */
  public static final String START_APPLICATION_PARAMETER = "start_application";

  /**
   * O nome do parmetro que define a URL do servidor. Essa URL  do tipo
   * nome:porta.
   */
  public static final String SERVER_URL_PARAMETER = "server_url";

  /**
   * O nome do parmetro que representa o identificador de usurio do token de
   * login do OpenBus.
   */
  public static final String OPENBUS_TOKEN_USER_PARAMETER =
    "openbus_token_user";

  /**
   * O nome do parmetro que representa se o desktop deve iniciar visvel.
   */
  public static final String DESKTOP_VISIBLE_PARAMETER = "desktop_visible";

  /**
   * O nome do parmetro que representa o identificador da instncia do cliente
   * corrente.
   */
  public static final String CURRENT_CLIENT_IDENTIFIER_PARAMETER =
    "current_client_identifier";

  /**
   * O nome do parmetro que representa o identificador da instncia do cliente
   * que originou a execuo deste cliente.
   */
  public static final String SOURCE_CLIENT_IDENTIFIER_PARAMETER =
    "source_client_identifier";

  /**
   * O nome do parmetro que representa o segredo do token de login do OpenBus.
   */
  public static final String OPENBUS_TOKEN_SECRET_PARAMETER =
    "openbus_token_secret";

  /**
   * O nome do parmetro que representa o IOR de um Servio de Dados do OpenBus.
   */
  public static final String DATA_SERVICE_IOR_PARAMETER = "data_service_ior";

  /**
   * O nome do parmetro que representa a porta pela qual o cliente deve
   * exportar seus objetos.
   */
  public static final String RMI_PORT_PARAMETER = "rmi_port";

  /**
   * Se atribudo o valor true, faz com que os processos executados pela EDT no
   * cliente sejam logados no formato:[tempo de execuo]ms: [evento]<br>
   * Exemplo:<br>
   * 827ms:
   * java.awt.event.MouseEvent[MOUSE_PRESSED,(172,82),absolute(255,176),button
   * =1,modifiers=Button1,extModifiers=Button1,clickCount=1] on frame3
   */
  public static final String LOG_EDT_PARAMETER = "log_edt";

  /**
   * O nome do parmetro que define a URL da aplicao. Essa URL  do tipo
   * http://nome:porta/[nome da aplicao]/.
   */
  public static final String URL_APP_PARAMETER = "app_url";

  /**
   * O nome parmetro que indica se o cliente deve usar o modo de otimizao de
   * acesso  rea de projetos. Seus valores possveis so: true ou false
   */
  public static final String OPT_MODE_PARAMETER = "client_optimization_mode";

  /**
   * Adiciona parmetros em uma URL textual (se o valor no for {@code null}).
   *
   * @param urlText url (texto)
   * @param paramName nome do parmetro
   * @param paramValue valor do parmetro
   * @return uma nova url (texto)
   */
  public static String addUrlParam(final String urlText, final String paramName,
    final String paramValue) {
    if (paramValue == null) {
      return urlText;
    }
    final String sufix = String.format("&%s=%s", paramName, paramValue);
    return urlText + sufix;
  }
}
