/*
 * $Id:$
 */

package csbase.remote;

import java.net.URL;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Locale;

import csbase.logic.openbus.OpenBusLoginToken;
import csbase.logic.openurlservice.PredefinedURLSystem;

/**
 * Interface do servio de aquisio de URLs de sietmas CSBASE.
 * 
 * @author Tecgraf/PUC-Rio
 */
public interface OpenURLServiceInterface extends ServiceInterface {

  /**
   * Nome do servio para o <code>ServiceManager</code>
   */
  public static final String SERVICE_NAME = "OpenURLService";

  /**
   * Retorna uma URL de um sistema CSBASE qualquer com base em uma tag
   * pr-configurada no servio.
   * 
   * @param locale locale
   * @param token o token de login do Openbus
   * @param systemLabel tag configurada no servio para escolha do
   *        servidor/sistema
   * @param currentClientId identificador do cliente que chamou a ao.
   * @param newClientId identificador para o novo cliente a ser lanado.
   * @param startVisible indicativo se o desktop deve aparecer como visvel.
   * @return a URL.
   * @throws RemoteException em caso de falha RMI.
   */
  public URL getSystemURL(Locale locale, OpenBusLoginToken token,
    String systemLabel, String currentClientId, String newClientId,
    boolean startVisible) throws RemoteException;

  /**
   * Retorna uma URL do prprio sistema.
   * 
   * @param locale locale
   * @param token o token de login do Openbus
   * @param currentClientId identificador do cliente que chamou a ao.
   * @param newClientId identificador para o novo cliente a ser lanado.
   * @param startVisible indicativo se o desktop deve aparecer como visvel.
   * @return a URL.
   * @throws RemoteException em caso de falha RMI.
   */
  public URL getURL(Locale locale, OpenBusLoginToken token,
    String currentClientId, String newClientId, boolean startVisible)
    throws RemoteException;

  /**
   * Montagem da lista de sistemas pr-configurados.
   * 
   * @return a lista
   * @throws RemoteException em caso de falha RMI.
   */
  public List<PredefinedURLSystem> getPredefinedURLSystems()
    throws RemoteException;

}
