/*
 * AdministrationEvent.java
 * 
 * $Author$ $Revision$ - $Date: 2011-08-01 15:35:08 -0300
 * (Mon, 01 Aug 2011) $
 */
package csbase.logic;

import csbase.remote.RemoteEvent;

/**
 * A classe <code>AdministrationEvent</code> representa um evento ocorrido no
 * servio de administrao. Os eventos podem ser de criao, modificao ou
 * remoo de algum objeto.
 * 
 * @author $Author$
 * @version $Revision$
 */
public class AdministrationEvent extends RemoteEvent {
  /** O evento de criao de um objeto no servio de administrao. */
  public static final int CREATE = 1;
  /** O evento de modificao de um objeto no servio de administrao. */
  public static final int MODIFY = 2;
  /** O evento de remoo de um objeto no servio de administrao. */
  public static final int DELETE = 3;
  /** Indica qual foi o evento ocorrido no servio de administrao. */
  public int type;
  /** Indica o objeto resultante do evento ocorrido. */
  public Object item;

  /**
   * Cria o objeto que representa um evento ocorrido no servio de
   * administrao.
   * 
   * @param type a ao ocorrida
   * @param item o objeto resultante da ao
   */
  public AdministrationEvent(int type, Object item) {
    this.type = type;
    this.item = item;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String toString() {
    String message = "";
    message +=
      "O evento  do tipo AdministrationEvent. Informaes especficas do evento: ";
    message += "Tipo : ";
    message += type + "\n";
    message += "Item : ";
    message += item.toString() + "\n";
    return message;
  }
}
