/*
 * AlgorithmsReloadNotificationData.java $Author$ $Revision$
 * - $Date$
 */
package csbase.logic;

/**
 * Classe que modela uma notificao de reload no servio de algoritmos
 * 
 * @author Andr Clinio
 */
public class AlgorithmsReloadNotification extends Notification {
  /**
   * String para auditagem.
   * 
   * @return uma string
   */
  @Override
  public String toString() {
    return "ALGORITHM RELOAD / NOTIFICATION";
  }

  /**
   * Definio da volatilidade da notificao.
   * 
   * @return flag indicativo.
   */
  @Override
  public boolean isVolatile() {
    return true;
  }

  /**
   * Constri o evento de notificao.
   * 
   * @param sender Quem est enviando a notificao (no pode ser {@code null}).
   */
  public AlgorithmsReloadNotification(String sender) {
    super(sender);
  }
}
